/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.http;

import com.help.common.exception.UnifyException;
import com.help.common.http.HttpFailException;
import com.help.common.http.SslUtils;
import com.help.common.util.BeanConvert;
import com.help.common.util.StreamUtils;
import com.help.common.util.StringUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Deprecated
public class HttpClientHelper {
    private static Logger logger = LoggerFactory.getLogger(HttpClientHelper.class);
    private static int connTimeout = 2000;
    private static int defaultReadTimeout = 30000;

    public static void download(String url, String localFileName) throws HttpFailException {
        block20: {
            HttpURLConnection connection = null;
            FileOutputStream os = null;
            try {
                String sampled;
                String spanId;
                connection = (HttpURLConnection)new URL(url).openConnection();
                String traceId = MDC.get((String)"X-B3-TraceId");
                if (StringUtil.isNotEmpty(traceId)) {
                    connection.setRequestProperty("X-B3-TraceId", traceId);
                }
                if (StringUtil.isNotEmpty(spanId = MDC.get((String)"X-B3-SpanId"))) {
                    connection.setRequestProperty("X-B3-ParentSpanId", spanId);
                    connection.setRequestProperty("X-B3-SpanId", UUID.randomUUID().toString().replace("-", "").substring(0, 16));
                }
                if (StringUtil.isNotEmpty(sampled = MDC.get((String)"X-Span-Export"))) {
                    if ("true".equalsIgnoreCase(sampled)) {
                        connection.setRequestProperty("X-B3-Sampled", "1");
                    } else {
                        connection.setRequestProperty("X-B3-Sampled", "0");
                    }
                }
                connection.setConnectTimeout(connTimeout);
                connection.setReadTimeout(defaultReadTimeout);
                if (connection.getResponseCode() == 200) {
                    InputStream is = connection.getInputStream();
                    os = new FileOutputStream(localFileName, false);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    break block20;
                }
                throw new HttpFailException(String.valueOf(connection.getResponseCode()));
            }
            catch (Exception err) {
                int stateCode = -1;
                if (connection != null) {
                    try {
                        stateCode = connection.getResponseCode();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new HttpFailException(String.valueOf(stateCode), (Throwable)err);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void initSSL() throws HttpFailException {
        try {
            SslUtils.ignoreSsl();
        }
        catch (Exception e) {
            throw new UnifyException("\u4fe1\u4efb\u6240\u6709SSL\u8bc1\u4e66\u5931\u8d25");
        }
    }

    public static String get(String url) throws HttpFailException {
        return HttpClientHelper.get(url, "utf-8", defaultReadTimeout);
    }

    public static String get(String url, int maxTimeoutMs) throws HttpFailException {
        return HttpClientHelper.get(url, "utf-8", maxTimeoutMs);
    }

    public static String get(String url, String encode, int maxTimeoutMs) throws HttpFailException {
        return HttpClientHelper.get(url, null, encode, maxTimeoutMs);
    }

    public static String get(String url, Map<String, String> header) throws HttpFailException {
        return HttpClientHelper.get(url, header, "utf-8", defaultReadTimeout);
    }

    public static String get(String url, Map<String, String> header, String encode, int maxTimeoutMs) throws HttpFailException {
        HttpClientHelper.initSSL();
        HttpURLConnection connection = null;
        try {
            String sampled;
            String spanId;
            connection = (HttpURLConnection)new URL(url).openConnection();
            String traceId = MDC.get((String)"X-B3-TraceId");
            if (StringUtil.isNotEmpty(traceId)) {
                connection.setRequestProperty("X-B3-TraceId", traceId);
            }
            if (StringUtil.isNotEmpty(spanId = MDC.get((String)"X-B3-SpanId"))) {
                connection.setRequestProperty("X-B3-ParentSpanId", spanId);
                connection.setRequestProperty("X-B3-SpanId", UUID.randomUUID().toString().replace("-", "").substring(0, 16));
            }
            if (StringUtil.isNotEmpty(sampled = MDC.get((String)"X-Span-Export"))) {
                if ("true".equalsIgnoreCase(sampled)) {
                    connection.setRequestProperty("X-B3-Sampled", "1");
                } else {
                    connection.setRequestProperty("X-B3-Sampled", "0");
                }
            }
            connection.setConnectTimeout(connTimeout);
            if (maxTimeoutMs > 0) {
                connection.setReadTimeout(maxTimeoutMs);
            }
            if (header != null) {
                for (String h : header.keySet()) {
                    String v = header.get(h);
                    if (!StringUtil.isNotEmpty(v)) continue;
                    connection.addRequestProperty(h, v);
                }
            }
            if (connection.getResponseCode() == 200) {
                String string = StreamUtils.copyToString(connection.getInputStream(), HttpClientHelper.getCharset(encode));
                return string;
            }
            try {
                throw new HttpFailException(String.valueOf(connection.getResponseCode()));
            }
            catch (Exception err) {
                int stateCode = -1;
                if (connection != null) {
                    try {
                        stateCode = connection.getResponseCode();
                        throw new HttpFailException(String.valueOf(stateCode), (Throwable)err);
                    }
                    catch (IOException e) {
                        throw new HttpFailException(String.valueOf(stateCode), (Throwable)e);
                    }
                }
                throw new HttpFailException(String.valueOf(stateCode), (Throwable)err);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String postJson(String url, Map<String, Object> params) throws HttpFailException {
        String json = BeanConvert.toJson(params);
        return HttpClientHelper.post(url, json, null, "utf-8", defaultReadTimeout, true);
    }

    public static String postJson(String url, Map<String, Object> params, Map<String, String> header) throws HttpFailException {
        String json = BeanConvert.toJson(params);
        return HttpClientHelper.post(url, json, header, "utf-8", defaultReadTimeout, true);
    }

    public static String postJson(String url, Map<String, Object> params, int maxTimeoutMs) throws HttpFailException {
        String json = BeanConvert.toJson(params);
        return HttpClientHelper.post(url, json, null, "utf-8", maxTimeoutMs, true);
    }

    public static String postJson(String url, Map<String, Object> params, Map<String, String> header, int maxTimeoutMs) throws HttpFailException {
        String json = BeanConvert.toJson(params);
        return HttpClientHelper.post(url, json, header, "utf-8", maxTimeoutMs, true);
    }

    public static String postJson(String url, Map<String, Object> params, String encode, int maxTimeoutMs) throws HttpFailException {
        String json = BeanConvert.toJson(params);
        return HttpClientHelper.post(url, json, null, encode, maxTimeoutMs, true);
    }

    public static String postJson(String url, Map<String, Object> params, Map<String, String> header, String encode, int maxTimeoutMs) throws HttpFailException {
        String json = BeanConvert.toJson(params);
        return HttpClientHelper.post(url, json, header, encode, maxTimeoutMs, true);
    }

    public static String post(String url, Map<String, String> params) throws HttpFailException {
        return HttpClientHelper.post(url, params, null, "utf-8", defaultReadTimeout);
    }

    public static String post(String url, Map<String, String> params, Map<String, String> header) throws HttpFailException {
        return HttpClientHelper.post(url, params, header, "utf-8", defaultReadTimeout);
    }

    public static String post(String url, Map<String, String> params, int maxTimeoutMs) throws HttpFailException {
        return HttpClientHelper.post(url, params, null, "utf-8", maxTimeoutMs);
    }

    public static String post(String url, Map<String, String> params, Map<String, String> header, int maxTimeoutMs) throws HttpFailException {
        return HttpClientHelper.post(url, params, header, "utf-8", maxTimeoutMs);
    }

    public static String post(String url, Map<String, String> params, String encode, int maxTimeoutMs) throws HttpFailException {
        return HttpClientHelper.post(url, params, null, encode, maxTimeoutMs);
    }

    public static String post(String url, Map<String, String> params, Map<String, String> header, String encode, int maxTimeoutMs) throws HttpFailException {
        String body = null;
        try {
            StringBuffer sb = new StringBuffer();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (!StringUtil.isNotEmpty(value)) continue;
                    sb.append(entry.getKey());
                    sb.append("=");
                    sb.append(URLEncoder.encode(value, "utf-8"));
                    sb.append("&");
                }
            }
            body = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
        }
        catch (Exception e) {
            throw new UnifyException("HTTP\u8bf7\u6c42\u53c2\u6570\u65e0\u6548:" + e.getMessage(), (Throwable)e);
        }
        return HttpClientHelper.post(url, body, header, encode, maxTimeoutMs, false);
    }

    private static String post(String url, String data, Map<String, String> header, String encode, int maxTimeoutMs, boolean isJson) throws HttpFailException {
        HttpClientHelper.initSSL();
        HttpURLConnection connection = null;
        try {
            String sampled;
            String spanId;
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            if (isJson) {
                connection.setRequestProperty("Content-Type", "application/json");
            } else {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            connection.setRequestProperty("encoding", "UTF-8");
            String traceId = MDC.get((String)"X-B3-TraceId");
            if (StringUtil.isNotEmpty(traceId)) {
                connection.setRequestProperty("X-B3-TraceId", traceId);
            }
            if (StringUtil.isNotEmpty(spanId = MDC.get((String)"X-B3-SpanId"))) {
                connection.setRequestProperty("X-B3-ParentSpanId", spanId);
                connection.setRequestProperty("X-B3-SpanId", UUID.randomUUID().toString().replace("-", "").substring(0, 16));
            }
            if (StringUtil.isNotEmpty(sampled = MDC.get((String)"X-Span-Export"))) {
                if ("true".equalsIgnoreCase(sampled)) {
                    connection.setRequestProperty("X-B3-Sampled", "1");
                } else {
                    connection.setRequestProperty("X-B3-Sampled", "0");
                }
            }
            connection.setConnectTimeout(connTimeout);
            if (maxTimeoutMs > 0) {
                connection.setReadTimeout(maxTimeoutMs);
            }
            if (header != null) {
                for (String h : header.keySet()) {
                    String v = header.get(h);
                    if (!StringUtil.isNotEmpty(v)) continue;
                    connection.addRequestProperty(h, v);
                }
            }
            byte[] bt = data.getBytes("UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(bt.length));
            if (logger.isDebugEnabled()) {
                Map<String, List<String>> headers = connection.getRequestProperties();
                StringBuffer sb = new StringBuffer();
                sb.append("--------------HTTP-START---------------\r\n");
                sb.append("POST:");
                sb.append(url);
                sb.append("\r\n--------------Header---------------\r\n");
                for (String k : headers.keySet()) {
                    if (headers.get(k) == null) continue;
                    sb.append(k);
                    sb.append("=");
                    sb.append(StringUtil.join((Iterable)headers.get(k), ","));
                    sb.append("\r\n");
                }
                sb.append("--------------Body---------------\r\n");
                sb.append(data);
                sb.append("\r\n--------------END---------------\r\n");
                logger.debug(sb.toString());
            }
            long current = System.currentTimeMillis();
            OutputStream os = connection.getOutputStream();
            os.write(bt);
            os.flush();
            os.close();
            if (connection.getResponseCode() == 200) {
                String result = StreamUtils.copyToString(connection.getInputStream(), HttpClientHelper.getCharset(encode));
                long span = System.currentTimeMillis() - current;
                if (span > 1000L) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("HTTP\u63a5\u53e3[{}]\u54cd\u5e94\u8fc7\u6162,\u54cd\u5e94\u65f6\u95f4[{}ms]", (Object)url, (Object)span);
                    } else {
                        logger.warn("HTTP\u63a5\u53e3[{}]\u54cd\u5e94\u8fc7\u6162,\u54cd\u5e94\u65f6\u95f4[{}ms],\u8bf7\u6c42\u4f53[{}]", new Object[]{url, span, data});
                    }
                }
                String string = result;
                return string;
            }
            try {
                long span = System.currentTimeMillis() - current;
                if (span > 1000L) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("HTTP\u63a5\u53e3[{}]\u54cd\u5e94\u8fc7\u6162,\u54cd\u5e94\u65f6\u95f4[{}ms]", (Object)url, (Object)span);
                    } else {
                        logger.warn("HTTP\u63a5\u53e3[{}]\u54cd\u5e94\u8fc7\u6162,\u54cd\u5e94\u65f6\u95f4[{}ms],\u8bf7\u6c42\u4f53[{}]", new Object[]{url, span, data});
                    }
                }
                throw new HttpFailException(String.valueOf(connection.getResponseCode()));
            }
            catch (Exception err) {
                int stateCode = -1;
                if (connection != null) {
                    try {
                        stateCode = connection.getResponseCode();
                        throw new HttpFailException(String.valueOf(stateCode), (Throwable)err);
                    }
                    catch (IOException e) {
                        throw new HttpFailException(String.valueOf(stateCode), (Throwable)e);
                    }
                }
                throw new HttpFailException(String.valueOf(stateCode), (Throwable)err);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static Charset getCharset(String name) {
        Charset charset = null;
        charset = StringUtil.isEmpty(name) ? Charset.forName("utf-8") : Charset.forName(name);
        return charset;
    }
}

