/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.util.StringUtil;

public class UnifyException
extends RuntimeException {
    private static final long serialVersionUID = -9090450565739536330L;
    protected UnifyErrorCode errorCode;
    protected String customState;
    protected String msg;

    public UnifyException() {
        this(UnifyErrorCode.UNKNOW_FAIL);
    }

    public UnifyException(UnifyErrorCode errorCode) {
        this(errorCode, errorCode.getMsg());
    }

    public UnifyException(UnifyErrorCode code, String msg) {
        this(code, null, msg, null);
    }

    public UnifyException(UnifyErrorCode code, Throwable e) {
        this(code, code.getMsg(), e);
    }

    public UnifyException(String msg) {
        this(UnifyErrorCode.UNKNOW_FAIL, msg);
    }

    public UnifyException(UnifyErrorCode errorCode, String customState, String msg) {
        this(errorCode, customState, msg, null);
    }

    public UnifyException(String msg, Throwable e) {
        this(UnifyErrorCode.UNKNOW_FAIL, null, msg, e);
    }

    public UnifyException(Throwable e) {
        this(UnifyErrorCode.UNKNOW_FAIL, null, null, e);
    }

    public UnifyException(UnifyErrorCode code, String msg, Throwable e) {
        this(code, null, msg, e);
    }

    public UnifyException(UnifyErrorCode code, String customState, String msg, Throwable e) {
        super(e);
        this.errorCode = code;
        this.customState = customState;
        this.msg = msg;
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    public UnifyErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getCustomState() {
        if (StringUtil.isNotEmpty(this.customState)) {
            return this.customState;
        }
        return this.errorCode.getCode();
    }

    @JsonIgnore
    public boolean isCustomState() {
        return StringUtil.isNotEmpty(this.customState);
    }

    public String getCrcbCommunicationCode() {
        if (StringUtil.isNotEmpty(this.customState)) {
            return this.customState;
        }
        return this.errorCode.getCrcbCommunicationCode();
    }
}

