/*
 * Decompiled with CFR 0.152.
 */
package com.help.common.exception;

public enum UnifyErrorCode {
    SUCCESS("000000", "000000", null, 0),
    BUSINESS_FAILD("100000", "020000", "\u4e1a\u52a1\u6267\u884c\u5931\u8d25", 2),
    FREQUENTLY("100003", "020001", "\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41", 1),
    RQEUIRED_LOGIN("200000", "020002", "\u60a8\u9700\u8981\u5148\u767b\u5f55\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c", 1),
    UN_AUTHORIZATION("200002", "020003", "\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c", 1),
    NON_DATA("100001", "020004", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728", 1),
    DATA_REPETITION("100002", "020005", "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6570\u636e,\u64cd\u4f5c\u5931\u8d25", 1),
    VALIDATE_FAILD("500000", "010000", "\u8bf7\u6c42\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", 1),
    NON_INTERFACE("500002", "010001", "\u8bf7\u6c42\u7684\u63a5\u53e3\u4e0d\u5b58\u5728", 1),
    REQ_TIMEOUT("600000", "030001", "\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u8d85\u65f6", 2),
    NETWORK_FAIL("600001", "050000", "\u670d\u52a1\u5668\u5185\u90e8\u901a\u8baf\u5931\u8d25", 1),
    TRANS_UNKNOW("100004", "999999", "\u4ea4\u6613\u72b6\u6001\u672a\u77e5,\u9700\u67e5\u8bc1", 3),
    UNKNOW_FAIL("999999", "999999", "\u8bf7\u6c42\u6267\u884c\u5931\u8d25(\u672a\u77e5\u9519\u8bef),\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", 4);

    private String code;
    private String crcbCode;
    private int level;
    private String msg;

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public int getLevel() {
        return this.level;
    }

    public String getCrcbCommunicationCode() {
        if (this.code.equals(UnifyErrorCode.SUCCESS.code)) {
            return this.code;
        }
        if ("true".equalsIgnoreCase(System.getProperty("help.context.enable-crcb-error-code", "false"))) {
            return "E" + System.getProperty("help.sys-id", "0000") + this.crcbCode;
        }
        return this.code;
    }

    private UnifyErrorCode(String code, String crcbCode, String msg, int level) {
        this.code = code;
        this.crcbCode = crcbCode;
        this.msg = msg;
        this.level = level;
    }

    public static UnifyErrorCode parse(String code) {
        UnifyErrorCode[] codes;
        for (UnifyErrorCode c : codes = UnifyErrorCode.values()) {
            if (!c.getCode().equals(code)) continue;
            return c;
        }
        return UNKNOW_FAIL;
    }
}

