/*
 * Decompiled with CFR 0.152.
 */
package com.help.common;

import com.help.common.IInvocationData;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;

public class InvocationResult<T> {
    public static InvocationResult SUCCESS = new InvocationResult();
    private String state;
    private String customState;
    private int level = 0;
    private String message;
    private T data;

    public InvocationResult() {
        this(UnifyErrorCode.SUCCESS);
    }

    public InvocationResult(T data) {
        this();
        this.data = data instanceof IInvocationData ? ((IInvocationData)data).getResult() : data;
    }

    public InvocationResult(IInvocationData<T> data) {
        this();
        if (data != null) {
            this.data = data.getResult();
        }
    }

    public InvocationResult(UnifyException exp) {
        this(exp.getErrorCode(), exp.getMessage());
        if (exp.isCustomState()) {
            this.customState = exp.getCustomState();
        }
    }

    public InvocationResult(UnifyException exp, String msg) {
        this(exp);
        this.message = msg;
    }

    public InvocationResult(UnifyErrorCode code, String message) {
        this(code);
        this.message = message;
    }

    public InvocationResult(UnifyErrorCode code, String customState, String msg) {
        this(code, msg);
        this.customState = customState;
    }

    public InvocationResult(UnifyErrorCode code) {
        this.state = code.getCode();
        this.message = code.getMsg();
        this.level = code.getLevel();
    }

    public String getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public int getLevel() {
        return this.level;
    }

    public void setData(T data) {
        this.data = data instanceof IInvocationData ? ((IInvocationData)data).getResult() : data;
    }

    public String getCustomState() {
        if (this.customState == null) {
            return this.state;
        }
        return this.customState;
    }
}

