/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import org.hibernate.type.Type;

public class CacheKeyImpl
implements DataSerializable {
    private Object id;
    private String entityOrRoleName;
    private String tenantId;
    private Type type;

    public CacheKeyImpl() {
    }

    public CacheKeyImpl(Object id, String entityOrRoleName, String tenantId, Type type) {
        this.id = id;
        this.entityOrRoleName = entityOrRoleName;
        this.tenantId = tenantId;
        this.type = type;
    }

    Object getId() {
        return this.id;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeUTF(this.entityOrRoleName);
        out.writeUTF(this.tenantId);
        out.writeObject((Object)this.type);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readObject();
        this.entityOrRoleName = in.readUTF();
        this.tenantId = in.readUTF();
        this.type = (Type)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKeyImpl cacheKey = (CacheKeyImpl)o;
        if (!this.type.isEqual(this.id, cacheKey.id)) {
            return false;
        }
        if (!this.entityOrRoleName.equals(cacheKey.entityOrRoleName)) {
            return false;
        }
        return this.tenantId != null ? this.tenantId.equals(cacheKey.tenantId) : cacheKey.tenantId == null;
    }

    public int hashCode() {
        int result = this.type.getHashCode(this.id);
        result = 31 * result + this.entityOrRoleName.hashCode();
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }
}

