/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class GsonUtils {
    private static final Gson GSON = new GsonBuilder().enableComplexMapKeySerialization().setDateFormat("yyyy-MM-dd HH:mm:ss").disableHtmlEscaping().create();
    private static final Gson GSON_NULL = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().setDateFormat("yyyy-MM-dd HH:mm:ss").disableHtmlEscaping().create();
    private static final Gson GSON_UNDERSCORES = new GsonBuilder().enableComplexMapKeySerialization().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setDateFormat("yyyy-MM-dd HH:mm:ss").disableHtmlEscaping().create();

    public static Gson getGson() {
        return GSON;
    }

    public static Gson getWriteNullGson() {
        return GSON_NULL;
    }

    public static String toJsonString(Object object) {
        return GSON.toJson(object);
    }

    public static String toWriteNullJsonString(Object object) {
        return GSON_NULL.toJson(object);
    }

    public static <T> T strToJavaBean(String json, Class<T> clazz) {
        return (T)GSON.fromJson(json, clazz);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return (T)GSON.fromJson(json, typeOfT);
    }

    public static <T> List<T> strToList(String gsonString, Class<T> cls) {
        return (List)GSON.fromJson(gsonString, new TypeToken<List<T>>(){}.getType());
    }

    public static <T> List<Map<String, T>> strToListMaps(String gsonString) {
        return (List)GSON.fromJson(gsonString, new TypeToken<List<Map<String, String>>>(){}.getType());
    }

    public static <T> Map<String, T> strToMaps(String gsonString) {
        return (Map)GSON.fromJson(gsonString, new TypeToken<Map<String, T>>(){}.getType());
    }

    public static JsonObject strToJsonObject(String jsonStr) {
        return JsonParser.parseString((String)jsonStr).getAsJsonObject();
    }

    public static String toJsonStringWithUnderscores(Object object) {
        return GSON_UNDERSCORES.toJson(object);
    }
}

