/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util.crypto.sm4;

import com.citicsf.common.core.enums.BaseResponseEnum;
import com.citicsf.common.core.exception.BaseException;
import com.citicsf.common.core.util.crypto.DigitTransferUtils;
import com.citicsf.common.core.util.crypto.sm4.SM4;
import com.citicsf.common.core.util.crypto.sm4.SM4_Context;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Utils {
    private static final Logger logger = LoggerFactory.getLogger(SM4Utils.class);
    public String secretKey = "";
    public String iv = "";
    public boolean hexString = false;

    public String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? DigitTransferUtils.hexStringToBytes(this.secretKey) : DigitTransferUtils.hexStringToBytes(this.secretKey);
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            return DigitTransferUtils.byteToHex(encrypted);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("encryptData_ECB Exception");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            byte[] encrypted = DigitTransferUtils.hexToByte(cipherText);
            cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? DigitTransferUtils.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("decryptData_ECB Exception");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = DigitTransferUtils.hexStringToBytes(this.secretKey);
                ivBytes = DigitTransferUtils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            return DigitTransferUtils.byteToHex(encrypted);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("encryptData_CBC Exception");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            byte[] encrypted = DigitTransferUtils.hexToByte(cipherText);
            cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = DigitTransferUtils.hexStringToBytes(this.secretKey);
                ivBytes = DigitTransferUtils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("decryptData_CBC Exception");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
    }

    public static void main(String[] args) throws IOException {
        String plainText = "I Love You Every Day";
        String s = DigitTransferUtils.byteToHex(plainText.getBytes());
        System.out.println("\u539f\u6587" + s);
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = "64EC7C763AB7BF64E2D75FF83A319918";
        sm4.hexString = true;
        System.out.println("ECB\u6a21\u5f0f\u52a0\u5bc6");
        String cipherText = sm4.encryptData_ECB(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        System.out.println("");
        String plainText2 = sm4.decryptData_ECB(cipherText);
        System.out.println("\u660e\u6587: " + plainText2);
        System.out.println("");
        System.out.println("CBC\u6a21\u5f0f\u52a0\u5bc6");
        sm4.iv = "31313131313131313131313131313131";
        String cipherText2 = sm4.encryptData_CBC(plainText);
        System.out.println("\u52a0\u5bc6\u5bc6\u6587: " + cipherText2);
        System.out.println("");
        String plainText3 = sm4.decryptData_CBC(cipherText2);
        System.out.println("\u89e3\u5bc6\u660e\u6587: " + plainText3);
    }
}

