/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util.crypto;

import com.citicsf.common.core.enums.BaseResponseEnum;
import com.citicsf.common.core.exception.BaseException;
import com.citicsf.common.core.util.crypto.DigitTransferUtils;
import com.citicsf.common.core.util.crypto.sm2.SM2EncDecUtils;
import com.citicsf.common.core.util.crypto.sm2.SM2KeyVO;
import com.citicsf.common.core.util.crypto.sm2.SM2SignVO;
import com.citicsf.common.core.util.crypto.sm2.SM2SignVerUtils;
import com.citicsf.common.core.util.crypto.sm4.SM4Utils;
import java.io.IOException;
import java.util.UUID;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoSMUtils {
    private static final Logger logger = LoggerFactory.getLogger(CryptoSMUtils.class);
    private static final String INIT_IV = "31313131313131313131313131313131";

    public static void generateSM2KeyPairs() {
        SM2KeyVO sm2KeyVO = SM2EncDecUtils.generateKeyPair();
        logger.info("\u516c\u94a5: {}", (Object)sm2KeyVO.getPubHexInSoft());
        logger.info("\u79c1\u94a5: {}", (Object)sm2KeyVO.getPriHexInSoft());
    }

    public static String sm2Enc(String pubHexKey, String src) {
        try {
            String encrypt = SM2EncDecUtils.encrypt(DigitTransferUtils.hexStringToBytes(pubHexKey), src.getBytes());
            encrypt = encrypt.substring(2);
            return encrypt;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            logger.error("sm2 encrypt IOException");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
    }

    public static String sm2Dec(String priHexKey, String encSrc) {
        byte[] decrypt = new byte[]{};
        try {
            encSrc = "04" + encSrc;
            decrypt = SM2EncDecUtils.decrypt(DigitTransferUtils.hexStringToBytes(priHexKey), DigitTransferUtils.hexStringToBytes(encSrc));
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            logger.error("sm2 decrypt IOException");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
        return new String(decrypt);
    }

    public static String sm2Sign(String priHexKey, String src) {
        String hexSource = DigitTransferUtils.byteToHex(src.getBytes());
        SM2SignVO sign = null;
        try {
            sign = SM2SignVerUtils.Sign2SM2(DigitTransferUtils.hexToByte(priHexKey), DigitTransferUtils.hexToByte(hexSource));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("sm2 sign IOException");
            throw new BaseException(BaseResponseEnum.FAIL.getCode(), BaseResponseEnum.FAIL.getMessage());
        }
        return sign.getSm2_signForSoft();
    }

    public static boolean sm2VerifySign(String pubHexKey, String src, String sign) {
        String hexSource = DigitTransferUtils.byteToHex(src.getBytes());
        SM2SignVO verify = SM2SignVerUtils.VerifySignSM2(DigitTransferUtils.hexStringToBytes(pubHexKey), DigitTransferUtils.hexToByte(hexSource), DigitTransferUtils.hexToByte(sign));
        return verify != null && verify.isVerify();
    }

    public static String sm3Hash(String src) {
        byte[] md = new byte[32];
        byte[] msg1 = src.getBytes();
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        return s.toUpperCase();
    }

    public static String sm4GenerateKey() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String sm4EncCbc(String sm4Key, String src) {
        return CryptoSMUtils.sm4EncCbc(sm4Key, src, INIT_IV);
    }

    public static String sm4DecCbc(String sm4Key, String encStr) {
        return CryptoSMUtils.sm4DecCbc(sm4Key, encStr, INIT_IV);
    }

    public static String sm4EncCbc(String sm4Key, String src, String iv) {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = sm4Key;
        sm4.hexString = true;
        sm4.iv = iv;
        String cipherText = sm4.encryptData_CBC(src);
        return cipherText;
    }

    public static String sm4DecCbc(String sm4Key, String encStr, String iv) {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = sm4Key;
        sm4.hexString = true;
        sm4.iv = iv;
        String plainText = sm4.decryptData_CBC(encStr);
        return plainText;
    }

    public static String sm4EncEcb(String sm4Key, String src) {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = sm4Key;
        sm4.hexString = true;
        String cipherText = sm4.encryptData_ECB(src);
        return cipherText;
    }

    public static String sm4DecEcb(String sm4Key, String encStr) {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = sm4Key;
        sm4.hexString = true;
        String plainText = sm4.decryptData_ECB(encStr);
        return plainText;
    }
}

