/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util;

import com.citicsf.common.core.enums.IResponseEnum;
import com.citicsf.common.core.exception.BaseException;
import com.citicsf.common.core.util.StringUtils;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BizAssert {
    private static final Logger logger = LoggerFactory.getLogger(BizAssert.class);

    public static void notNull(Object obj, String code, String message) {
        if (obj == null) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static void notNull(Object obj, IResponseEnum responseEnum) {
        BizAssert.notNull(obj, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static void isNull(Object obj, String code, String message) {
        if (obj != null) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static void isNull(Object obj, IResponseEnum responseEnum) {
        BizAssert.isNull(obj, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static void isTrue(boolean bool, String code, String message) {
        if (!bool) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static void isTrue(boolean bool, IResponseEnum responseEnum) {
        BizAssert.isTrue(bool, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static void isFalse(boolean bool, String code, String message) {
        BizAssert.isTrue(!bool, code, message);
    }

    public static void isNotBlank(String str, String code, String message) {
        if (StringUtils.isBlank((CharSequence)str)) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static void isNotBlank(String str, IResponseEnum responseEnum) {
        BizAssert.isNotBlank(str, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static void hasText(String str, String code, String message) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static void hasText(String str, IResponseEnum responseEnum) {
        BizAssert.hasText(str, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static <T> void isEmpty(Collection<T> collection, String code, String message) {
        if (collection != null && !collection.isEmpty()) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static <T> void isEmpty(Collection<T> collection, IResponseEnum responseEnum) {
        BizAssert.isEmpty(collection, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static <T> void notEmpty(Collection<T> collection, String code, String message) {
        if (collection == null || collection.isEmpty()) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static <T> void notEmpty(Collection<T> collection, IResponseEnum responseEnum) {
        BizAssert.notEmpty(collection, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static <K, V> void notEmptyMap(Map<K, V> map, String code, String message) {
        if (map == null || map.isEmpty()) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static <K, V> void notEmptyMap(Map<K, V> map, IResponseEnum responseEnum) {
        BizAssert.notEmptyMap(map, responseEnum.getCode(), responseEnum.getMessage());
    }

    public static <K, V> void isEmptyMap(Map<K, V> map, String code, String message) {
        if (map != null && !map.isEmpty()) {
            BizAssert.throwMessage(code, message);
        }
    }

    public static <K, V> void isEmptyMap(Map<K, V> map, IResponseEnum responseEnum) {
        BizAssert.isEmptyMap(map, responseEnum.getCode(), responseEnum.getMessage());
    }

    private static void throwMessage(String code, String message) {
        throw new BaseException(code, message);
    }

    private static void printLog(String logMsg) {
        logger.error(logMsg);
    }

    public static void notNull(Object obj, String code, String message, String logMsg) {
        if (obj == null) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static void notNull(Object obj, IResponseEnum responseEnum, String logMsg) {
        BizAssert.notNull(obj, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static void isNull(Object obj, String code, String message, String logMsg) {
        if (obj != null) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static void isNull(Object obj, IResponseEnum responseEnum, String logMsg) {
        BizAssert.isNull(obj, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static void isTrue(boolean bool, String code, String message, String logMsg) {
        if (!bool) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static void isTrue(boolean bool, IResponseEnum responseEnum, String logMsg) {
        BizAssert.isTrue(bool, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static void isFalse(boolean bool, String code, String message, String logMsg) {
        BizAssert.isTrue(!bool, code, message, logMsg);
    }

    public static void isNotBlank(String str, String code, String message, String logMsg) {
        if (StringUtils.isBlank((CharSequence)str)) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static void isNotBlank(String str, IResponseEnum responseEnum, String logMsg) {
        BizAssert.isNotBlank(str, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static void hasText(String str, String code, String message, String logMsg) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static void hasText(String str, IResponseEnum responseEnum, String logMsg) {
        BizAssert.hasText(str, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static <T> void isEmpty(Collection<T> collection, String code, String message, String logMsg) {
        if (collection != null && !collection.isEmpty()) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static <T> void isEmpty(Collection<T> collection, IResponseEnum responseEnum, String logMsg) {
        BizAssert.isEmpty(collection, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static <T> void notEmpty(Collection<T> collection, String code, String message, String logMsg) {
        if (collection == null || collection.isEmpty()) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static <T> void notEmpty(Collection<T> collection, IResponseEnum responseEnum, String logMsg) {
        BizAssert.notEmpty(collection, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static <K, V> void notEmptyMap(Map<K, V> map, String code, String message, String logMsg) {
        if (map == null || map.isEmpty()) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static <K, V> void notEmptyMap(Map<K, V> map, IResponseEnum responseEnum, String logMsg) {
        BizAssert.notEmptyMap(map, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }

    public static <K, V> void isEmptyMap(Map<K, V> map, String code, String message, String logMsg) {
        if (map != null && !map.isEmpty()) {
            BizAssert.printLog(logMsg);
            BizAssert.throwMessage(code, message);
        }
    }

    public static <K, V> void isEmptyMap(Map<K, V> map, IResponseEnum responseEnum, String logMsg) {
        BizAssert.isEmptyMap(map, responseEnum.getCode(), responseEnum.getMessage(), logMsg);
    }
}

