/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.response;

import com.citicsf.common.core.enums.BaseResponseEnum;
import com.citicsf.common.core.enums.IResponseEnum;
import com.citicsf.common.core.exception.BaseException;
import java.io.Serializable;

public class BaseResponse<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String message;
    private E data;

    public static <E> BaseResponse<E> ok(E data) {
        BaseResponse<E> response = BaseResponse.of(BaseResponseEnum.SUCCESS);
        response.setData(data);
        return response;
    }

    public static <E> BaseResponse<E> ok() {
        return BaseResponse.of(BaseResponseEnum.SUCCESS);
    }

    public static <E> BaseResponse<E> fail(E data) {
        BaseResponse<E> response = BaseResponse.of(BaseResponseEnum.FAIL);
        response.setData(data);
        return response;
    }

    public static <E> BaseResponse<E> fail() {
        return BaseResponse.of(BaseResponseEnum.FAIL);
    }

    public static <E> BaseResponse<E> of(BaseException baseException) {
        return BaseResponse.of(baseException.getCode(), baseException.getMessage());
    }

    public static <E> BaseResponse<E> of(IResponseEnum iResponseEnum) {
        return BaseResponse.of(iResponseEnum.getCode(), iResponseEnum.getMessage());
    }

    public static <E> BaseResponse<E> of(String code, String msg) {
        BaseResponse<E> baseResponse = new BaseResponse<E>();
        baseResponse.code = code;
        baseResponse.message = msg;
        return baseResponse;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public E getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(E data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        E this$data = this.getData();
        E other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        E $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

