/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.exception.hanlder;

import com.citicsf.common.core.enums.BaseResponseEnum;
import com.citicsf.common.core.exception.BaseException;
import com.citicsf.common.core.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.dao.DataAccessException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public BaseResponse base(BaseException e) {
        log.error(e.getMessage(), (Throwable)e);
        return BaseResponse.of(e);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class, HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, HttpMediaTypeNotAcceptableException.class, ServletRequestBindingException.class, ConversionNotSupportedException.class, MissingServletRequestPartException.class, AsyncRequestTimeoutException.class})
    public BaseResponse handleServletException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return BaseResponse.of(BaseResponseEnum.FAIL);
    }

    @ExceptionHandler(value={BindException.class})
    public BaseResponse handleBindException(BindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        return BaseResponse.of(BaseResponseEnum.FAIL);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public BaseResponse handleValidException(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        return BaseResponse.of(BaseResponseEnum.FAIL);
    }

    @ExceptionHandler(value={DataAccessException.class})
    public BaseResponse handleDataAccessException(DataAccessException e) {
        log.error("\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
        return BaseResponse.of(BaseResponseEnum.FAIL);
    }

    @ExceptionHandler(value={Exception.class})
    public BaseResponse handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return BaseResponse.of(BaseResponseEnum.FAIL);
    }

    private BaseResponse wrapperBindingResult(BindingResult bindingResult) {
        StringBuilder msg = new StringBuilder();
        for (ObjectError error : bindingResult.getAllErrors()) {
            msg.append(", ");
            if (error instanceof FieldError) {
                msg.append(((FieldError)error).getField()).append(": ");
            }
            msg.append(error.getDefaultMessage() == null ? "" : error.getDefaultMessage());
        }
        return BaseResponse.of("999999", msg.substring(2));
    }
}

