/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.exception;

import com.citicsf.common.core.enums.BaseResponseEnum;
import com.citicsf.common.core.enums.IResponseEnum;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String code = BaseResponseEnum.FAIL.getCode();
    private String message = BaseResponseEnum.FAIL.getMessage();

    public BaseException() {
    }

    public BaseException(String message) {
        super(message);
        this.message = message;
    }

    public BaseException(String code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }

    public BaseException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.message = message;
    }

    public BaseException(IResponseEnum iResponseEnum) {
        super(iResponseEnum.getMessage());
        this.code = iResponseEnum.getCode();
        this.message = iResponseEnum.getMessage();
    }

    public BaseException(IResponseEnum iResponseEnum, String extraMsg) {
        super(iResponseEnum.getMessage());
        this.code = iResponseEnum.getCode();
        this.message = iResponseEnum.formatMsg(extraMsg);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

