/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util.crypto.sm3;

import com.citicsf.common.core.util.crypto.DigitTransferUtils;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;

public class SM3 {
    public static final byte[] iv;
    public static int[] Tj;

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM3.convert(V);
        int[] b = SM3.convert(B);
        return SM3.convert(SM3.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < arr.length; i += 4) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = SM3.bigEndianByteToInt(tmp);
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        for (int i = 0; i < arr.length; ++i) {
            tmp = SM3.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM3.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int ss1 = SM3.bitCycleLeft(a, 12) + e + SM3.bitCycleLeft(Tj[j], j);
            ss1 = SM3.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ SM3.bitCycleLeft(a, 12);
            int tt1 = SM3.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = SM3.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = SM3.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = SM3.bitCycleLeft(f, 19);
            f = e;
            e = SM3.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(int[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (i = 0; i < B.length; ++i) {
            W[i] = B[i];
        }
        for (i = 16; i < 68; ++i) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static byte[] bigEndianIntToByte(int num) {
        return SM3.back(DigitTransferUtils.intToBytes(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return DigitTransferUtils.byteToInt(SM3.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.FF1j(X, Y, Z);
        }
        return SM3.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.GG1j(X, Y, Z);
        }
        return SM3.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        int y = SM3.rotateLeft(X, 9);
        y = SM3.bitCycleLeft(X, 9);
        int z = SM3.rotateLeft(X, 17);
        z = SM3.bitCycleLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private static int P1(int X) {
        int t = X ^ SM3.bitCycleLeft(X, 15) ^ SM3.bitCycleLeft(X, 23);
        return t;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = SM3.back(DigitTransferUtils.longToBytes(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }

    public static int rotateLeft(int x, int n) {
        return x << n | x >> 32 - n;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = SM3.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = SM3.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = SM3.bitSmall8CycleLeft(tmp, len);
        }
        return SM3.bigEndianByteToInt(tmp);
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        for (int i = 0; i < tmp.length; ++i) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
        }
        return tmp;
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    public static void main(String[] args) {
        byte[] md = new byte[32];
        byte[] msg1 = "ererfeiisgod".getBytes();
        System.out.println(DigitTransferUtils.byteToHex(msg1));
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        System.out.println(s.toUpperCase());
    }

    static {
        int i;
        iv = new byte[]{115, -128, 22, 111, 73, 20, -78, -71, 23, 36, 66, -41, -38, -118, 6, 0, -87, 111, 48, -68, 22, 49, 56, -86, -29, -115, -18, 77, -80, -5, 14, 78};
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            SM3.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            SM3.Tj[i] = 2055708042;
        }
    }
}

