/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util;

import com.citicsf.common.core.enums.BaseResponseEnum;
import com.citicsf.common.core.response.BaseResponse;

public class ResponseUtil {
    public static <T> BaseResponse success(T data) {
        return ResponseUtil.response(BaseResponseEnum.SUCCESS, data);
    }

    public static BaseResponse success() {
        return ResponseUtil.response(BaseResponseEnum.SUCCESS, null);
    }

    public static <T> BaseResponse fail(String message, T data) {
        return ResponseUtil.response(BaseResponseEnum.FAIL.getCode(), message, data);
    }

    public static <T> BaseResponse fail(T data) {
        return ResponseUtil.response(BaseResponseEnum.FAIL, data);
    }

    public static BaseResponse fail() {
        return ResponseUtil.response(BaseResponseEnum.FAIL, null);
    }

    public static BaseResponse response(String code, String message) {
        return ResponseUtil.response(code, message, null);
    }

    public static <T> BaseResponse response(String code, String message, T data) {
        BaseResponse<T> result = new BaseResponse<T>();
        result.setCode(code);
        result.setMessage(message);
        result.setData(data);
        return result;
    }

    private static BaseResponse response(BaseResponseEnum re) {
        return ResponseUtil.response(re, null);
    }

    private static <T> BaseResponse response(BaseResponseEnum re, T data) {
        return ResponseUtil.response(re.getCode(), re.getMessage(), data);
    }

    public static void main(String[] args) {
        System.out.println(ResponseUtil.fail().toString());
    }
}

