/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String[] PATTERN1 = new String[]{"yyyy-MM", "yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS"};
    public static final String[] PATTERN2 = new String[]{"yyyy/MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.SSS"};
    public static final String[] PATTERN3 = new String[]{"yyyyMM", "yyyyMMdd", "yyyyMMdd HH:mm", "yyyyMMdd HH:mm:ss", "yyyyMMdd HH:mm:ss.SSS"};
    public static final String[] PATTERN4 = new String[]{"yyyy.MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss.SSS"};
    private static final int MONTH = Calendar.getInstance().get(2) + 1;

    public static LocalDateTime date2LocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static LocalDate date2LocalDate(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date string2date(String dateStr, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            log.error("Errors occur when execute date2String ", (Throwable)e);
            return null;
        }
    }

    public static String date2String(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static String getCurrentTime(String dateFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        Date date = new Date();
        return df.format(date);
    }

    public static String getTimestamp() {
        String current = String.valueOf(System.currentTimeMillis());
        return current;
    }

    public static String getDateByString(String dateFormat) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static long dateSubtraction(String start, String end, String dateFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            Date date1 = df.parse(start);
            Date date2 = df.parse(end);
            return date2.getTime() - date1.getTime();
        }
        catch (ParseException e) {
            log.error("Errors occur when exec dateSubtraction ", (Throwable)e);
            return 0L;
        }
    }

    public static long dateTogether(Date start, Date end) {
        return end.getTime() - start.getTime();
    }

    public static String transferLongToDate(String millSec, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = new Date(Long.parseLong(millSec));
        return sdf.format(date);
    }

    public static int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(7) - 1;
    }

    public static boolean isEffectiveDate(Date nowTime, String dateSection, String dateFormat) {
        try {
            String[] times = dateSection.split(",");
            Date startTime = new SimpleDateFormat(dateFormat).parse(times[0]);
            Date endTime = new SimpleDateFormat(dateFormat).parse(times[1]);
            if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
                return true;
            }
            Calendar date = Calendar.getInstance();
            date.setTime(nowTime);
            Calendar begin = Calendar.getInstance();
            begin.setTime(startTime);
            Calendar end = Calendar.getInstance();
            end.setTime(endTime);
            if (DateUtil.isSameDay(date, begin) || DateUtil.isSameDay(date, end)) {
                return true;
            }
            return date.after(begin) && date.before(end);
        }
        catch (Exception e) {
            log.error("Errors occur when exec isEffectiveDate ", (Throwable)e);
            return false;
        }
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static long getTimeByDate(String time, String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        try {
            Date date = format.parse(time);
            return date.getTime();
        }
        catch (Exception e) {
            log.error("Errors occur when exec getTimeByDate ", (Throwable)e);
            return 0L;
        }
    }

    public static String getBeforeDay(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return sdf.format(date);
    }

    public static String getServen(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Calendar c = Calendar.getInstance();
        c.add(5, -7);
        Date monday = c.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static String getOneMonth(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        Date monday = c.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static String getThreeMonth(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Calendar c = Calendar.getInstance();
        c.add(2, -3);
        Date monday = c.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static String getOneYear(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        Date start = c.getTime();
        String startDay = sdf.format(start);
        return startDay;
    }

    public static List getMonthList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= MONTH; ++i) {
            list.add(i);
        }
        return list;
    }

    public static List getQuartList() {
        int quart = MONTH / 3 + 1;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= quart; ++i) {
            list.add(i);
        }
        return list;
    }

    public static void main(String[] args) {
        String str = DateUtil.getBeforeDay(PATTERN3[1]);
        System.out.println(str);
    }
}

