/*
 * Decompiled with CFR 0.152.
 */
package com.citicsf.common.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.objenesis.ObjenesisStd;

public final class BeanCopierUtil {
    private static final ThreadLocal<ObjenesisStd> objenesisStdThreadLocal = ThreadLocal.withInitial(ObjenesisStd::new);
    private static final ConcurrentHashMap<Class<?>, ConcurrentHashMap<Class<?>, BeanCopier>> cache = new ConcurrentHashMap();

    public static <T> T copy(Object source, Class<T> target) {
        return (T)BeanCopierUtil.copy(source, objenesisStdThreadLocal.get().newInstance(target));
    }

    private static <T> T copy(Object source, T target) {
        BeanCopier beanCopier = BeanCopierUtil.getCacheBeanCopier(source.getClass(), target.getClass());
        beanCopier.copy(source, target, null);
        return target;
    }

    public static <T> List<T> copyList(List<?> sources, Class<T> target) {
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(sources.size());
        ObjenesisStd objenesisStd = objenesisStdThreadLocal.get();
        for (Object source : sources) {
            if (source == null) {
                return new ArrayList();
            }
            Object newInstance = objenesisStd.newInstance(target);
            BeanCopier beanCopier = BeanCopierUtil.getCacheBeanCopier(source.getClass(), target);
            beanCopier.copy(source, newInstance, null);
            list.add(newInstance);
        }
        return list;
    }

    public static <T> T mapToBean(Map<?, ?> source, Class<T> target) {
        Object bean = objenesisStdThreadLocal.get().newInstance(target);
        BeanMap beanMap = BeanMap.create((Object)bean);
        beanMap.putAll(source);
        return (T)bean;
    }

    public static <T> Map<?, ?> beanToMap(T source) {
        return BeanMap.create(source);
    }

    private static <S, T> BeanCopier getCacheBeanCopier(Class<S> source, Class<T> target) {
        ConcurrentHashMap copierConcurrentHashMap = cache.computeIfAbsent(source, aClass -> new ConcurrentHashMap(16));
        return copierConcurrentHashMap.computeIfAbsent(target, aClass -> BeanCopier.create((Class)source, (Class)target, (boolean)false));
    }
}

