/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.utils;

import cn.com.yusys.yusp.common.utils.KeyValueConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GenericBuilder<T> {
    private final Supplier<T> instantiator;
    private List<Consumer<T>> instantiatorModifiers = new ArrayList<Consumer<T>>();
    private List<Consumer<T>> keyValueModifiers = new ArrayList<Consumer<T>>();

    public GenericBuilder(Supplier<T> instantiator) {
        this.instantiator = instantiator;
    }

    public static <T> GenericBuilder<T> of(Supplier<T> instantiator) {
        return new GenericBuilder<T>(instantiator);
    }

    public <U> GenericBuilder<T> with(BiConsumer<T, U> consumer, U value) {
        Consumer<Object> c = instance -> consumer.accept(instance, value);
        this.instantiatorModifiers.add(c);
        return this;
    }

    public <K, V> GenericBuilder<T> with(KeyValueConsumer<T, K, V> consumer, K key, V value) {
        Consumer<Object> c = instance -> consumer.accept(instance, key, value);
        this.keyValueModifiers.add(c);
        return this;
    }

    public T build() {
        Object value = this.instantiator.get();
        this.instantiatorModifiers.forEach(modifier -> modifier.accept(value));
        this.keyValueModifiers.forEach(keyValueModifier -> keyValueModifier.accept(value));
        this.instantiatorModifiers.clear();
        this.keyValueModifiers.clear();
        return value;
    }
}

