/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.exception;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.module.adapter.exception.YuspException;
import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483648)
public class PlusExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(PlusExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResultDto handleException(Exception e) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        return ResultDto.error((String)"500", (String)e.getMessage());
    }

    @ExceptionHandler(value={BizException.class})
    public ResultDto<Object> handleBizException(BizException e) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aBizException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        return StringUtils.isEmpty((CharSequence)e.getErrorCode()) ? ResultDto.error((String)e.getMessage()) : ResultDto.error((String)e.getErrorCode(), (String)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultDto handleValidationExceptions(MethodArgumentNotValidException ex) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aMethodArgumentNotValidException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)ex);
        return ResultDto.error((String)"400", (String)ex.getBindingResult().getAllErrors().stream().map(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            return fieldName + ": " + errorMessage;
        }).collect(Collectors.joining()));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResultDto handleConstraintViolationExceptions(ConstraintViolationException ex) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aConstraintViolationException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)ex);
        return ResultDto.error((String)"400", (String)ex.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(",")));
    }

    @ExceptionHandler(value={YuspException.class})
    public ResultDto handleException(YuspException e) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aYuspExcepiton,\u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        return ResultDto.error((String)e.getCode(), (String)e.getMessage());
    }
}

