/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.aspect;

import cn.com.yusys.yusp.common.annotation.Metrics;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ConditionalOnProperty(value={"application.metrics.enable"}, havingValue="true")
@Aspect
@Order(value=-2147483648)
public class MetricsAspect {
    private static final Logger log = LoggerFactory.getLogger(MetricsAspect.class);
    private static final Map<Class<?>, Object> DEFAULT_VALUES = Stream.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE).collect(Collectors.toMap(clazz -> clazz, clazz -> Array.get(Array.newInstance(clazz, 1), 0)));
    @Autowired
    ObjectMapper objectMapper;
    public static final String MULTIPART = "multipart/";

    public static <T> T getDefaultValue(Class<T> clazz) {
        return (T)DEFAULT_VALUES.get(clazz);
    }

    @Pointcut(value="@annotation(cn.com.yusys.yusp.common.annotation.Metrics)")
    public void withMetricsAnnotation() {
    }

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public void controllerBean() {
    }

    @Around(value="controllerBean() || withMetricsAnnotation()")
    public Object metrics(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object returnValue;
        HttpServletRequest request;
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        String classAndMethodName = String.format("\u3010%s\u3011", methodSignature.toLongString());
        Metrics metrics = methodSignature.getMethod().getAnnotation(Metrics.class);
        if (metrics == null) {
            metrics = methodSignature.getMethod().getDeclaringClass().getAnnotation(Metrics.class);
        }
        if (metrics == null) {
            @Metrics
            final class TempClass {
                TempClass() {
                }
            }
            metrics = TempClass.class.getAnnotation(Metrics.class);
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        boolean isFileUploadRequest = false;
        if (requestAttributes != null && (request = ((ServletRequestAttributes)requestAttributes).getRequest()) != null) {
            classAndMethodName = classAndMethodName + String.format("\u3010%s\u3011", request.getRequestURI());
            isFileUploadRequest = this.isMultipartContent(request);
        }
        if (metrics.logParameters() && !isFileUploadRequest) {
            try {
                log.info("\u8c03\u7528 {} \u7684\u3010\u5165\u53c2\u3011\uff1a\u3010{}\u3011", (Object)classAndMethodName, (Object)this.objectMapper.writeValueAsString((Object)proceedingJoinPoint.getArgs()));
            }
            catch (JsonProcessingException e) {
                log.warn("\u8c03\u7528 {} \u7684request\u5bf9\u8c61JSON\u5e8f\u5217\u5316\u51fa\u9519\uff0c\u5ffd\u7565\u5f02\u5e38\uff0c\u8bf7\u5f00\u53d1\u4eba\u5458\u5173\u6ce8\u6b64\u9519\u8bef\uff1a{}", (Object)classAndMethodName, (Object)e);
            }
        }
        Instant start = Instant.now();
        try {
            returnValue = proceedingJoinPoint.proceed();
            if (metrics.recordSuccessMetrics()) {
                log.info("\u8c03\u7528 {} \u6210\u529f\uff0c\u8017\u65f6\uff1a{} ms", (Object)classAndMethodName, (Object)Duration.between(start, Instant.now()).toMillis());
            }
        }
        catch (Exception e) {
            if (metrics.recordFailMetrics()) {
                log.info("\u8c03\u7528 {} \u5931\u8d25\uff0c\u8017\u65f6\uff1a{} ms", (Object)classAndMethodName, (Object)Duration.between(start, Instant.now()).toMillis());
            }
            if (metrics.logException()) {
                log.error("\u8c03\u7528 {} \u51fa\u73b0\u5f02\u5e38", (Object)classAndMethodName, (Object)e);
            }
            if (metrics.ignoreException()) {
                returnValue = MetricsAspect.getDefaultValue(methodSignature.getReturnType());
            }
            throw e;
        }
        if (metrics.logReturn()) {
            log.info("\u8c03\u7528 {} \u7684\u3010\u8fd4\u56de\u503c\u3011\uff1a \u3010{}\u3011", (Object)classAndMethodName, (Object)this.objectMapper.writeValueAsString(returnValue));
        }
        return returnValue;
    }

    private boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }
}

