/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.user.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.resource.Resource;
import cn.com.yusys.yusp.msm.util.RsaUtil;
import cn.com.yusys.yusp.user.domain.User;
import cn.com.yusys.yusp.user.service.UserService;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
public class UserResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);

    UserService getUserService() {
        return (UserService)this.getService(UserService.class);
    }

    @GetMapping(value={"/publickey"})
    public ResultDto<String> getPublicKey() {
        ResultDto resultDto = new ResultDto();
        try {
            String publicKey = this.getUserService().getKey("public_key");
            resultDto.setData((Object)publicKey);
        }
        catch (IOException e) {
            resultDto.setMessage("\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
        }
        return resultDto;
    }

    @GetMapping(value={"/list"})
    public ResultDto<List<User>> getUserList(QueryModel queryModel) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3\uff1a/api/user/list \u67e5\u8be2\u7528\u6237\u5217\u8868");
        List<User> userList = this.getUserService().getUserList((String)queryModel.getCondition().get("cluster"));
        return new ResultDto((long)userList.size(), userList);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addUser(@RequestBody @Valid User user) throws Exception {
        logger.info("\u8bf7\u6c42\u63a5\u53e3\uff1a /api/user/ \u6dfb\u52a0\u7528\u6237\uff0c\u8bf7\u6c42\u53c2\u6570 user: {}", (Object)user);
        if (user.getId() == null || user.getId().equals("")) {
            user.setId(UUID.randomUUID().toString());
        }
        PrivateKey privateKey = RsaUtil.getPrivateKey((String)this.getUserService().getKey("private_key"));
        String pwd = RsaUtil.decrypt((String)user.getPassword(), (Key)privateKey);
        user.setPassword(pwd);
        int addUserResult = this.getUserService().addUser(user);
        if (addUserResult == 1) {
            return new ResultDto((Object)"success");
        }
        if (addUserResult == 0) {
            ResultDto dto = new ResultDto((Object)"error");
            dto.setMessage("\u8d26\u53f7\u5df2\u5b58\u5728");
            return dto;
        }
        return new ResultDto((Object)"error");
    }

    @PostMapping(value={"/{userId}"})
    public ResultDto<Object> getUserByUserId(@RequestBody Map<String, String> data) throws Exception {
        PrivateKey privateKey = RsaUtil.getPrivateKey((String)this.getUserService().getKey("private_key"));
        String pwd = RsaUtil.decrypt((String)data.get("password"), (Key)privateKey);
        User user = this.getUserService().getUserByUserId(data.get("username"));
        if (user == null || !new BCryptPasswordEncoder().matches((CharSequence)pwd, user.getPassword())) {
            return new ResultDto(0, 0L, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", (Object)"");
        }
        return new ResultDto(1, 1L, "\u767b\u5f55\u6210\u529f", (Object)user);
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delUserByIds(@PathVariable(value="ids") String ids) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/user/delete/ \u5220\u9664\u7528\u6237\uff0c\u8bf7\u6c42\u53c2\u6570 ids\uff1a{}", (Object)ids);
        try {
            this.getUserService().delUserByIds(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

