/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.user.service.impl;

import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.msm.util.RsaUtil;
import cn.com.yusys.yusp.user.domain.User;
import cn.com.yusys.yusp.user.repository.mapper.ClusterRelMapper;
import cn.com.yusys.yusp.user.repository.mapper.UserMapper;
import cn.com.yusys.yusp.user.service.UserService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@StorageType(serviceType="database")
public class UserServiceDBImpl
implements UserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    ClusterRelMapper clusterRelMapper;
    @Value(value="${public-key}")
    String publicKeyPath;
    @Value(value="${private-key}")
    String privateKeyPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKey(String keyName) throws IOException {
        String path = keyName.equals("public_key") ? this.publicKeyPath : this.privateKeyPath;
        ClassPathResource resource = new ClassPathResource(path);
        Key key = null;
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(resource.getInputStream());
            key = (Key)ois.readObject();
        }
        return RsaUtil.getKeyBase64((Key)key);
    }

    @Override
    public int addUser(User user) {
        User u = this.userMapper.getUserByUserId(user.getUserId());
        if (u == null) {
            this.addUserClusterRel(user);
            LogUtil.info((Object)ModulNameConstant.USERMANAGER, (String)"\u65b0\u589e\u7528\u6237 {}", (Object[])new Object[]{user.getUserName()});
            user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)user.getPassword()));
            return this.userMapper.addUser(user);
        }
        if (u.getId().equals(user.getId())) {
            LogUtil.info((Object)ModulNameConstant.USERMANAGER, (String)"\u4fee\u6539\u7528\u6237 {} \u7684\u4fe1\u606f", (Object[])new Object[]{user.getUserName()});
            if (u.getPassword().substring(0, 35).equals(user.getPassword())) {
                user.setPassword(u.getPassword());
            } else {
                user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)user.getPassword()));
            }
            return this.updateUser(user);
        }
        return 0;
    }

    public int updateUser(User user) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(user.getUserId());
        this.clusterRelMapper.deleteUserClusterRel(userIdList);
        this.addUserClusterRel(user);
        return this.userMapper.updateUser(user);
    }

    public void addUserClusterRel(User user) {
        if (user.getClusters() != null) {
            String[] clusterIds;
            for (String clusterId : clusterIds = user.getClusters()) {
                String relId = UUID.randomUUID().toString();
                this.clusterRelMapper.addUserClusterRel(relId, user.getUserId(), clusterId);
            }
        }
    }

    @Override
    public List<User> getUserList(String cluster) {
        List<User> users = this.userMapper.getUserList();
        ArrayList<User> list = new ArrayList<User>();
        for (User user : users) {
            List<String> clusterList = this.clusterRelMapper.getClusterIdFromUserClusterRelByUserId(user.getUserId());
            if (!StringUtils.isEmpty((Object)cluster) && !clusterList.contains(cluster)) continue;
            user.setClusters(clusterList.toArray(new String[clusterList.size()]));
            user.setPassword(user.getPassword().substring(0, 35));
            list.add(user);
        }
        return list;
    }

    @Override
    public User getUserByUserId(String userId) {
        User user;
        if (userId != null && (user = this.userMapper.getUserByUserId(userId)) != null) {
            List<String> clusterList = this.clusterRelMapper.getClusterIdFromUserClusterRelByUserId(user.getUserId());
            clusterList.toArray();
            user.setClusters(clusterList.toArray(new String[clusterList.size()]));
            return user;
        }
        return null;
    }

    @Override
    public void delUserByIds(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (String id : idArray) {
            User u = this.userMapper.getUserById(id);
            if (null == u) continue;
            idList.add(u.getUserId());
            sb.append(u.getUserName() + ",");
        }
        this.userMapper.delUserByIds(idArray);
        LogUtil.info((Object)ModulNameConstant.USERMANAGER, (String)("\u5220\u9664\u7528\u6237 " + sb.toString().substring(0, sb.toString().length() - 1)), (Object[])new Object[0]);
        this.clusterRelMapper.deleteUserClusterRel(idList);
    }
}

