/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.user.repository;

import cn.com.yusys.yusp.msm.config.CommonProperties;
import cn.com.yusys.yusp.msm.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.log.repository.CommonRepository;
import cn.com.yusys.yusp.user.domain.User;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class UserRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(UserRepository.class);

    public UserRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{User.class});
    }

    public void addAndUpdateUser(User userDomain) {
        List<User> userList = this.getUserList();
        boolean updateFlag = false;
        for (User userItem : userList) {
            if (!userItem.getId().equals(userDomain.getId())) continue;
            updateFlag = true;
            BeanUtils.copyProperties((Object)userDomain, (Object)userItem);
        }
        if (!updateFlag) {
            userList.add(userDomain);
        }
        try {
            this.getAfo().writeObject(userList);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            if (updateFlag) {
                this.log.error("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25: {} error: {}", (Object)userDomain, (Object)e.getMessage());
            }
            this.log.error("\u6dfb\u52a0\u7528\u6237\u4fe1\u606f\u5931\u8d25: {} error: {}", (Object)userDomain, (Object)e.getMessage());
        }
    }

    public List<User> getUserList() {
        ArrayList userList = (ArrayList)this.getLoadObj();
        if (userList == null) {
            userList = new ArrayList();
        }
        return userList;
    }

    public User getUserByUserId(String userId) {
        List userList = (List)this.getLoadObj();
        if (userList != null) {
            for (User item : userList) {
                if (!userId.equals(item.getUserId())) continue;
                return item;
            }
        }
        this.log.error("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u7528\u6237\u540d\uff1a{}", (Object)userId);
        return null;
    }

    public void delUserByIds(String ids) {
        List<User> userList = this.getUserList();
        ArrayList<User> removeList = null;
        List<String> idList = Arrays.asList(ids.split(","));
        for (User user : userList) {
            if (!idList.contains(user.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<User>();
            }
            removeList.add(user);
        }
        if (removeList == null) {
            return;
        }
        userList.removeAll(removeList);
        try {
            this.getAfo().writeObject(userList);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.log.error("\u5220\u9664\u7528\u6237\u5931\u8d25: " + Arrays.asList(ids) + " error: " + e.getMessage());
        }
    }
}

