/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.monitor.web.rest;

import cn.com.yusys.yusp.monitor.domain.ApmMonitorDomain;
import cn.com.yusys.yusp.monitor.service.Elsearch4ApiAndApmRestService;
import cn.com.yusys.yusp.msm.common.ResultDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elsearch"})
public class ElsearchApiAndApmResource {
    @Autowired
    Elsearch4ApiAndApmRestService elsearch4ApiAndApmRestService;

    @RequestMapping(value={"/monitorApiBasic/apiRpmList"}, method={RequestMethod.POST})
    public ResultDto<List> getApiBasicList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String timeFormat = apmMonitorDomain.getFormat();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        String intervalStr = apmMonitorDomain.getInterval();
        ArrayList<String> configApi = apmMonitorDomain.getConfigApi();
        DateHistogramInterval interval = this.getInterval(intervalStr);
        List<Histogram.Bucket> resultList = this.elsearch4ApiAndApmRestService.apiBasicMetricsSearch(timeFormat, from, to, interval, configApi);
        if (null != resultList) {
            result.setData(resultList);
            result.setMessage("success");
        } else {
            result.setMessage("failed");
        }
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/apiDetailList"}, method={RequestMethod.POST})
    public ResultDto<List> getApiDetailList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        int size = apmMonitorDomain.getSize();
        String orderType = apmMonitorDomain.getOrderType();
        ArrayList<String> configApi = apmMonitorDomain.getConfigApi();
        double timeThreshold = Double.valueOf(apmMonitorDomain.getTimeThreshold()) * 1000.0;
        String apiName = apmMonitorDomain.getApiName();
        String serviceName = apmMonitorDomain.getServiceName();
        double[] timeThresholdArry = new double[]{timeThreshold};
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apiBasicDetailSearch(from, to, size, orderType, apiName, serviceName, timeThresholdArry, configApi);
        result.setData(resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/apiInfoListByCondition"}, method={RequestMethod.POST})
    public ResultDto<List> getApiListByCondition(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        int size;
        ResultDto result = new ResultDto();
        String value = apmMonitorDomain.getValue();
        String field = apmMonitorDomain.getField();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apiInfoListSearchByCondition(field, value, size = 10);
        if (null != resultList) {
            result.setData(resultList);
            result.setMessage("success");
        } else {
            result.setMessage("failed");
        }
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/searchRespTimeAggs"}, method={RequestMethod.POST})
    public ResultDto<List> getRespTimeAggs(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        String to;
        String from;
        ResultDto result = new ResultDto();
        String value = apmMonitorDomain.getValue();
        String field = apmMonitorDomain.getField();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.searchRespTimeAggs(field, value, from = apmMonitorDomain.getFrom(), to = apmMonitorDomain.getTo());
        if (null != resultList) {
            result.setData(resultList);
            result.setMessage("success");
        } else {
            result.setMessage("failed");
        }
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/searchRespAvgTimeWithInterval"}, method={RequestMethod.POST})
    public ResultDto<Map> getRespAvgTimeWithInterval(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        String intervalStr;
        DateHistogramInterval interval;
        String format;
        String to;
        String from;
        ResultDto result = new ResultDto();
        String value = apmMonitorDomain.getValue();
        String field = apmMonitorDomain.getField();
        Map resultList = this.elsearch4ApiAndApmRestService.searchRespAvgTimeWithInterval(field, value, from = apmMonitorDomain.getFrom(), to = apmMonitorDomain.getTo(), format = apmMonitorDomain.getFormat(), interval = this.getInterval(intervalStr = apmMonitorDomain.getInterval()));
        if (null != resultList) {
            result.setData((Object)resultList);
            result.setMessage("success");
        } else {
            result.setMessage("failed");
        }
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/heightErrorApiInfoListByParam"}, method={RequestMethod.POST})
    public ResultDto<List> getLowSuccessApiListByParam(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        String to;
        String from;
        ResultDto result = new ResultDto();
        String value = apmMonitorDomain.getValue();
        String field = apmMonitorDomain.getField();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.heightErrorApiInfoListSearch(field, value, from = apmMonitorDomain.getFrom(), to = apmMonitorDomain.getTo());
        if (null != resultList) {
            result.setData(resultList);
            result.setMessage("success");
        } else {
            result.setMessage("failed");
        }
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/searchCount"}, method={RequestMethod.POST})
    public ResultDto<Map> searchCountByParam(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String value = apmMonitorDomain.getValue();
        String field = apmMonitorDomain.getField();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        Map resultList = this.elsearch4ApiAndApmRestService.searchCount(field, value, from, to);
        result.setData((Object)resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/searchErrorDetailList"}, method={RequestMethod.POST})
    public ResultDto<Map> searchErrorDetailByParam(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String value = apmMonitorDomain.getValue();
        String field = apmMonitorDomain.getField();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        String timeFormat = apmMonitorDomain.getFormat();
        String intervalStr = apmMonitorDomain.getInterval();
        int size = 10;
        DateHistogramInterval interval = this.getInterval(intervalStr);
        Map resultMap = this.elsearch4ApiAndApmRestService.searchErrorDetail(field, value, from, to, size, timeFormat, interval);
        result.setData((Object)resultMap);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApmBasic/apmRpmList"}, method={RequestMethod.POST})
    public ResultDto<List> getApmBasicList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        String timeFormat = apmMonitorDomain.getFormat();
        String intervalStr = apmMonitorDomain.getInterval();
        int size = apmMonitorDomain.getSize();
        DateHistogramInterval interval = this.getInterval(intervalStr);
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apmBasicMetricsSearch(timeFormat, from, to, interval, size);
        if (null != resultList) {
            result.setData(resultList);
            result.setMessage("success");
        } else {
            result.setMessage("failed");
        }
        return result;
    }

    @RequestMapping(value={"/monitorApmBasic/apmDetailList"}, method={RequestMethod.POST})
    public ResultDto<List> getApmDetailList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        int size = apmMonitorDomain.getSize();
        String orderType = apmMonitorDomain.getOrderType();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apmBasicDetailSearch(from, to, size, orderType);
        result.setData(resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApmBasic/apmRespTimeDetailList"}, method={RequestMethod.POST})
    public ResultDto<List> getApmRespTimeDetailList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        int size = apmMonitorDomain.getSize();
        String orderType = apmMonitorDomain.getOrderType();
        String nodeIp = apmMonitorDomain.getNodeIp();
        String serviceName = apmMonitorDomain.getServiceName();
        String timeThreshold = apmMonitorDomain.getTimeThreshold();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apmRespTimeDetailSearch(from, to, size, orderType, nodeIp, serviceName, timeThreshold);
        result.setData(resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApmBasic/apmErrorDetailList"}, method={RequestMethod.POST})
    public ResultDto<List> getApmErrorDetailList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String serviceName = apmMonitorDomain.getServiceName();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        int size = apmMonitorDomain.getSize();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apmErrorDetailSearch(serviceName, from, to, size);
        result.setData(resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/apiErrorCountList"}, method={RequestMethod.POST})
    public ResultDto<List> apiErrorCountList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String serviceName = apmMonitorDomain.getServiceName();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        int size = apmMonitorDomain.getSize();
        List<Map> resultList = this.elsearch4ApiAndApmRestService.apmErrorDetailSearch(serviceName, from, to, size);
        result.setData(resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/queryApiDetailHitsList"}, method={RequestMethod.POST})
    public ResultDto<Object> queryApiDetailHitsList(@RequestBody ApmMonitorDomain apmMonitorDomain) {
        ResultDto result = new ResultDto();
        String apiName = apmMonitorDomain.getApiName();
        String orderType = apmMonitorDomain.getOrderType();
        String serviceName = apmMonitorDomain.getServiceName();
        String from = apmMonitorDomain.getFrom();
        String to = apmMonitorDomain.getTo();
        int size = apmMonitorDomain.getSize();
        int page = apmMonitorDomain.getPage();
        int fromIndex = (page - 1) * size;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        Map resultList = this.elsearch4ApiAndApmRestService.queryApiDetailHitsList(from, to, fromIndex, size, serviceName, apiName, orderType);
        result.setData(resultList.get("hits"));
        result.setTotal(((Long)resultList.get("total")).longValue());
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/saveApiConfigData"}, method={RequestMethod.POST})
    public ResultDto<Map> saveApiConfigData(@RequestBody Map<String, Object> paramMap) {
        ResultDto result = new ResultDto();
        String index = "";
        String type = "";
        String id = "";
        String data = "";
        if (paramMap.containsKey("index")) {
            index = (String)paramMap.get("index");
        }
        if (paramMap.containsKey("type")) {
            type = (String)paramMap.get("type");
        }
        if (paramMap.containsKey("id")) {
            id = (String)paramMap.get("id");
        }
        if (paramMap.containsKey("data")) {
            data = (String)paramMap.get("data");
        }
        Map resultList = this.elsearch4ApiAndApmRestService.saveApiConfigData(index, type, id, data);
        result.setData((Object)resultList);
        result.setMessage("success");
        return result;
    }

    @RequestMapping(value={"/monitorApiBasic/searchApiConfigData"}, method={RequestMethod.POST})
    public ResultDto<Map> searchApiConfigData(@RequestBody Map<String, Object> paramMap) {
        ResultDto result = new ResultDto();
        String index = "";
        String type = "";
        String id = "";
        if (paramMap.containsKey("index")) {
            index = (String)paramMap.get("index");
        }
        if (paramMap.containsKey("type")) {
            type = (String)paramMap.get("type");
        }
        if (paramMap.containsKey("id")) {
            id = (String)paramMap.get("id");
        }
        Map resultList = this.elsearch4ApiAndApmRestService.searchApiConfigData(index, type, id);
        result.setData((Object)resultList);
        result.setMessage("success");
        return result;
    }

    private DateHistogramInterval getInterval(String intervalStr) {
        DateHistogramInterval interval = DateHistogramInterval.MINUTE;
        switch (intervalStr) {
            case "1s": {
                interval = DateHistogramInterval.SECOND;
                break;
            }
            case "1m": {
                interval = DateHistogramInterval.MINUTE;
                break;
            }
            case "1h": {
                interval = DateHistogramInterval.HOUR;
                break;
            }
            case "1d": {
                interval = DateHistogramInterval.DAY;
                break;
            }
            case "1w": {
                interval = DateHistogramInterval.WEEK;
                break;
            }
            case "1M": {
                interval = DateHistogramInterval.MONTH;
                break;
            }
            case "1q": {
                interval = DateHistogramInterval.QUARTER;
                break;
            }
            case "1y": {
                interval = DateHistogramInterval.YEAR;
                break;
            }
            default: {
                interval = DateHistogramInterval.MINUTE;
            }
        }
        return interval;
    }

    private List<String> getPagedList(int page, int size, List<String> res) {
        int toIndex;
        int fromIndex;
        if (page == 0) {
            page = 1;
        }
        if ((fromIndex = (page - 1) * size) >= res.size()) {
            return Collections.emptyList();
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((toIndex = page * size) >= res.size()) {
            toIndex = res.size();
        }
        return res.subList(fromIndex, toIndex);
    }
}

