/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.monitor.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Elsearch4MysqlService {
    private final Logger log = LoggerFactory.getLogger(Elsearch4MysqlService.class);
    @Autowired
    private RestHighLevelClient restClient;
    private static final RequestOptions COMMON_OPTIONS;

    public List<String> mysqlPeriodSearch(String ip, String queryTimeStr) throws Exception {
        ArrayList<String> resList = null;
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"filebeat-*"});
            searchRequest.types(new String[]{"doc"});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder builder = QueryBuilders.boolQuery();
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"ip", (String)ip));
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"documentType", (String)"mysql"));
            String[] queryTime = queryTimeStr.split(" - ");
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"time").from((Object)queryTime[0].replace(" ", "T")).to((Object)queryTime[1].replace(" ", "T")));
            searchSourceBuilder.query((QueryBuilder)builder).timeout(new TimeValue(60L, TimeUnit.SECONDS)).size(5000);
            searchSourceBuilder.sort("time", SortOrder.DESC);
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.restClient.search(searchRequest, COMMON_OPTIONS);
            this.log.info("MySQLBeat\u76d1\u63a7\u6570\u636e\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)searchResponse);
            if (searchResponse.getHits().totalHits == 0L) {
                return null;
            }
            if ("OK".equals(searchResponse.status().toString())) {
                SearchHit[] searchHits;
                resList = new ArrayList<String>();
                for (SearchHit hit : searchHits = searchResponse.getHits().getHits()) {
                    String res = hit.getSourceAsString();
                    resList.add(res);
                }
                System.out.println(searchResponse.getHits().totalHits);
            } else {
                this.log.warn("\u67e5\u8be2\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.log.error("MySQLBeat\u76d1\u63a7\u6570\u636e\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            throw new Exception("MySQLBeat\u76d1\u63a7\u6570\u636e\u67e5\u8be2\u62a5\u9519\uff1a" + e.getMessage());
        }
        return resList;
    }

    static {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        COMMON_OPTIONS = builder.build();
    }
}

