/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.monitor.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanksAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.ParsedValueCount;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Elsearch4ApiAndApmRestService {
    private final Logger log = LoggerFactory.getLogger(Elsearch4ApiAndApmRestService.class);
    @Autowired
    private RestHighLevelClient restClient;

    public List<Histogram.Bucket> apiBasicMetricsSearch(String timeFormat, String from, String to, DateHistogramInterval interval, List<String> configApi) {
        Histogram result = null;
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            DateHistogramAggregationBuilder aggregation = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"basicrRpm").field("@timestamp")).dateHistogramInterval(interval).format(timeFormat)).timeZone(DateTimeZone.forID((String)"+08:00"));
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            if (configApi.size() > 0) {
                TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"context.request.url.pathname", configApi);
                boolQueryBuilder.filter((QueryBuilder)termsQueryBuilder);
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            result = (Histogram)response.getAggregations().get("basicrRpm");
        }
        catch (IOException e) {
            this.log.error("API\u76d1\u63a7\u6570\u636e\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        if (null != result) {
            return result.getBuckets();
        }
        return null;
    }

    public List<Map> apiBasicDetailSearch(String from, String to, int size, String orderType, String apiName, String serviceName, double[] timeThreshold, List<String> configApi) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            ValuesSourceAggregationBuilder aggregationAvg = AggregationBuilders.avg((String)"avg_respTime").field("transaction.duration.us");
            PercentilesAggregationBuilder aggregationJw = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)"jw_avg_respTime").field("transaction.duration.us")).percentiles(new double[]{95.0});
            ValuesSourceAggregationBuilder aggregationMax = AggregationBuilders.max((String)"max_respTime").field("transaction.duration.us");
            ValuesSourceAggregationBuilder aggregationMin = AggregationBuilders.min((String)"min_respTime").field("transaction.duration.us");
            ValuesSourceAggregationBuilder aggregationError = AggregationBuilders.count((String)"error_count").field("error.id");
            TermsAggregationBuilder aggregationService = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"service_term").field("context.service.name")).order(BucketOrder.aggregation((String)"_count", (boolean)false)).size(5);
            TermsAggregationBuilder apiAggregation = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"api_term").field("context.request.url.pathname")).size(size).subAggregation((AggregationBuilder)aggregationAvg)).subAggregation((AggregationBuilder)aggregationJw)).subAggregation((AggregationBuilder)aggregationMin)).subAggregation((AggregationBuilder)aggregationMax)).subAggregation((AggregationBuilder)aggregationError)).subAggregation((AggregationBuilder)aggregationService);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            if (apiName.isEmpty() && serviceName.isEmpty()) {
                MatchAllQueryBuilder matchAllQueryBuilder = QueryBuilders.matchAllQuery();
                boolQueryBuilder.must((QueryBuilder)matchAllQueryBuilder);
            }
            if (!apiName.isEmpty()) {
                apiName = "*" + apiName + "*";
                WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)"context.request.url.pathname", (String)apiName);
                boolQueryBuilder.must((QueryBuilder)wildcardQueryBuilder);
            }
            if (!serviceName.isEmpty()) {
                MatchQueryBuilder matchBuilder = QueryBuilders.matchQuery((String)"context.service.name", (Object)serviceName);
                boolQueryBuilder.must((QueryBuilder)matchBuilder);
            }
            if (configApi.size() > 0) {
                TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"context.request.url.pathname", configApi);
                boolQueryBuilder.filter((QueryBuilder)termsQueryBuilder);
            }
            BucketOrder order = BucketOrder.aggregation((String)"_count", (boolean)false);
            if ("avgRespTime".equals(orderType)) {
                order = BucketOrder.aggregation((String)"avg_respTime", (boolean)false);
            } else if ("reqCount".equals(orderType)) {
                order = BucketOrder.aggregation((String)"_count", (boolean)false);
            } else if ("errorCount".equals(orderType)) {
                order = BucketOrder.aggregation((String)"error_count", (boolean)false);
                ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
                boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            } else if (!(timeThreshold[0] > 0.0)) {
                order = BucketOrder.aggregation((String)"avg_respTime", (boolean)false);
            } else {
                PercentileRanksAggregationBuilder percentRanksAggr = (PercentileRanksAggregationBuilder)AggregationBuilders.percentileRanks((String)"loadtime_term", (double[])timeThreshold).field("transaction.duration.us");
                ((TermsAggregationBuilder)apiAggregation.subAggregation((AggregationBuilder)percentRanksAggr)).order(BucketOrder.aggregation((String)"loadtime_term", (String)((int)timeThreshold[0] + ""), (boolean)true));
            }
            apiAggregation.order(order);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)apiAggregation);
            searchSourceBuilder.size(size);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms apiBucket = (Terms)response.getAggregations().get("api_term");
            List list = apiBucket.getBuckets();
            for (Terms.Bucket apiEntry : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String apiName2 = (String)apiEntry.getKey();
                long apiCount = apiEntry.getDocCount();
                Map subaggmap = apiEntry.getAggregations().asMap();
                double maxRespTime = ((ParsedMax)subaggmap.get("max_respTime")).getValue();
                double minRespTime = ((ParsedMin)subaggmap.get("min_respTime")).getValue();
                double avgRespTime = ((ParsedAvg)subaggmap.get("avg_respTime")).getValue();
                double errorCount = ((ParsedValueCount)subaggmap.get("error_count")).getValue();
                double jwAvgRespTime = 0.0;
                Percentiles percentiles = (Percentiles)subaggmap.get("jw_avg_respTime");
                for (Percentile entry : percentiles) {
                    jwAvgRespTime = entry.getValue();
                }
                Terms serviceList = (Terms)apiEntry.getAggregations().get("service_term");
                String tempServiceName = ((Terms.Bucket)serviceList.getBuckets().get(0)).getKeyAsString();
                this.log.debug("apiName [{}], maxRespTime [{}], minRespTime[{}], avgRespTime[{}], jwAvgRespTime[{}], errorCount[{}]", new Object[]{apiName2, maxRespTime, minRespTime, avgRespTime, jwAvgRespTime, errorCount});
                if (timeThreshold[0] > 0.0 && avgRespTime < timeThreshold[0]) continue;
                map.put("serviceName", tempServiceName);
                map.put("apiName", apiName2);
                map.put("apiCount", apiCount);
                map.put("maxRespTime", maxRespTime);
                map.put("minRespTime", minRespTime);
                map.put("avgRespTime", avgRespTime);
                map.put("errorCount", errorCount);
                map.put("jwAvgRespTime", jwAvgRespTime);
                resultList.add(map);
            }
        }
        catch (IOException e) {
            this.log.error("API\u76d1\u63a7\u6570\u636e\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return resultList;
    }

    public List<Map> apiInfoListSearchByCondition(String field, String value, int size) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)"now-7d").to((Object)"now");
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            if (value.isEmpty()) {
                MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
                boolQueryBuilder.must((QueryBuilder)queryBuilder);
            } else {
                value = "*" + value + "*";
                WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)field, (String)value);
                boolQueryBuilder.must((QueryBuilder)wildcardQueryBuilder);
            }
            TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"api_term").field(field)).size(size).order(BucketOrder.aggregation((String)"_count", (boolean)false));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms result = (Terms)response.getAggregations().get("api_term");
            for (Terms.Bucket entry : result.getBuckets()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String key = (String)entry.getKey();
                long docCount = entry.getDocCount();
                map.put("apiName", key);
                resultList.add(map);
                this.log.debug("key [{}], doc_count [{}]", (Object)key, (Object)docCount);
            }
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6[{}={}]\u67e5\u8be2\u6240\u6709\u6570\u636e\u65f6\u5217\u8868\u67e5\u8be2\u62a5\u9519\uff1a{}", new Object[]{field, value, e.getMessage()});
        }
        return resultList;
    }

    public List<Map> searchRespTimeAggs(String field, String value, String from, String to) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)field, (Object)value);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder).must((QueryBuilder)matchQueryBuilder);
            ValuesSourceAggregationBuilder aggregationAvg = AggregationBuilders.avg((String)"avg_respTime").field("transaction.duration.us");
            PercentilesAggregationBuilder aggregationJw = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)"jw_avg_respTime").field("transaction.duration.us")).percentiles(new double[]{95.0});
            TermsAggregationBuilder aggregation = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"api_term").field(field)).order(BucketOrder.aggregation((String)"_count", (boolean)false)).size(5).subAggregation((AggregationBuilder)aggregationAvg)).subAggregation((AggregationBuilder)aggregationJw);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms result = (Terms)response.getAggregations().get("api_term");
            for (Terms.Bucket apiEntry : result.getBuckets()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String apiName = (String)apiEntry.getKey();
                long apiCount = apiEntry.getDocCount();
                Map subaggmap = apiEntry.getAggregations().asMap();
                double avgRespTime = ((ParsedAvg)subaggmap.get("avg_respTime")).getValue();
                double jwAvgRespTime = 0.0;
                Percentiles percentiles = (Percentiles)subaggmap.get("jw_avg_respTime");
                for (Percentile entry : percentiles) {
                    jwAvgRespTime = entry.getValue();
                    map.put("jwAvgRespTime", jwAvgRespTime);
                }
                this.log.debug("apiName [{}], avgRespTime[{}]", (Object)apiName, (Object)avgRespTime);
                map.put("apiName", apiName);
                map.put("apiCount", apiCount);
                map.put("avgRespTime", avgRespTime);
                resultList.add(map);
            }
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6\u805a\u5408\u67e5\u8be2\u63a5\u53e3{}\u7684\u54cd\u5e94\u65f6\u95f4\u6570\u636e\u65f6\u62a5\u9519\uff1a{}", (Object)value, (Object)e.getMessage());
        }
        return resultList;
    }

    public Map searchRespAvgTimeWithInterval(String field, String value, String from, String to, String timeFormat, DateHistogramInterval interval) {
        HashMap resultMap = new HashMap();
        try {
            ExtendedBounds extendedBounds;
            ArrayList<String> timeList = new ArrayList<String>();
            ArrayList<Long> countList = new ArrayList<Long>();
            ArrayList<Double> respTimeList = new ArrayList<Double>();
            try {
                extendedBounds = new ExtendedBounds(Long.valueOf(Long.parseLong(from)), Long.valueOf(Long.parseLong(to)));
            }
            catch (Exception e) {
                extendedBounds = new ExtendedBounds(from, to);
            }
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            ValuesSourceAggregationBuilder aggregationAvg = AggregationBuilders.avg((String)"avg_respTime").field("transaction.duration.us");
            DateHistogramAggregationBuilder aggregation = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"basicrRpm").field("@timestamp")).dateHistogramInterval(interval).format(timeFormat)).timeZone(DateTimeZone.forID((String)"+08:00"))).extendedBounds(extendedBounds).subAggregation((AggregationBuilder)aggregationAvg);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)field, (Object)value);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder).must((QueryBuilder)matchQueryBuilder);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Histogram result = (Histogram)response.getAggregations().get("basicrRpm");
            for (Histogram.Bucket apiEntry : result.getBuckets()) {
                String time = apiEntry.getKeyAsString();
                long apiCount = apiEntry.getDocCount();
                Map subaggmap = apiEntry.getAggregations().asMap();
                double avgRespTime = 0.0;
                if (apiCount != 0L && (avgRespTime = ((ParsedAvg)subaggmap.get("avg_respTime")).getValue()) == Double.POSITIVE_INFINITY) {
                    avgRespTime = 0.0;
                }
                this.log.debug("time [{}], apiCount [{}], avgRespTime[{}]", new Object[]{time, apiCount, avgRespTime});
                timeList.add(time);
                countList.add(apiCount);
                respTimeList.add(Math.ceil(avgRespTime / 1000.0));
            }
            resultMap.put("timeList", timeList);
            resultMap.put("countList", countList);
            resultMap.put("respTimeList", respTimeList);
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6\u805a\u5408\u67e5\u8be2\u63a5\u53e3{}\u7684\u54cd\u5e94\u65f6\u95f4\u6570\u636e\u65f6\u62a5\u9519\uff1a{}", (Object)value, (Object)e.getMessage());
        }
        return resultMap;
    }

    public List<Map> heightErrorApiInfoListSearch(String field, String value, String from, String to) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            if (value.isEmpty()) {
                MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
                boolQueryBuilder.must((QueryBuilder)queryBuilder);
            } else {
                value = "*" + value + "*";
                WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)field, (String)value);
                boolQueryBuilder.must((QueryBuilder)wildcardQueryBuilder);
            }
            ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
            boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"error_term").field(field)).size(10).order(BucketOrder.aggregation((String)"_count", (boolean)false));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms result = (Terms)response.getAggregations().get("error_term");
            for (Terms.Bucket entry : result.getBuckets()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String key = (String)entry.getKey();
                long docCount = entry.getDocCount();
                map.put("field", key);
                map.put("count", docCount);
                resultList.add(map);
                this.log.debug("key [{}], doc_count [{}]", (Object)key, (Object)docCount);
            }
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6[{}={}]\u67e5\u8be2\u6240\u6709\u9ad8\u9519\u8bef\u6b21\u6570\u6570\u636e\u65f6\u62a5\u9519\uff1a{}", new Object[]{field, value, e.getMessage()});
        }
        return resultList;
    }

    public Map searchCount(String field, String value, String from, String to) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)field, (Object)value);
            boolQueryBuilder.must((QueryBuilder)matchQueryBuilder);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            long allCount = response.getHits().getTotalHits();
            ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
            boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            SearchResponse response2 = this.restClient.search(searchRequest, new Header[0]);
            long errorCount = response2.getHits().getTotalHits();
            resultMap.put("allCount", allCount);
            resultMap.put("errorCount", errorCount);
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6[{}={}]\u67e5\u8be2\u5339\u914d\u6587\u6863\u6570\u76ee\u65f6\u62a5\u9519\uff1a{}", new Object[]{field, value, e.getMessage()});
        }
        return resultMap;
    }

    public Map searchErrorDetail(String field, String value, String from, String to, int size, String timeFormat, DateHistogramInterval interval) {
        HashMap resultMap = new HashMap();
        try {
            ExtendedBounds extendedBounds;
            try {
                extendedBounds = new ExtendedBounds(Long.valueOf(Long.parseLong(from)), Long.valueOf(Long.parseLong(to)));
            }
            catch (Exception e) {
                extendedBounds = new ExtendedBounds(from, to);
            }
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)field, (Object)value);
            boolQueryBuilder.must((QueryBuilder)matchQueryBuilder);
            ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
            boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            DateHistogramAggregationBuilder aggregation = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"basicrRpm").field("@timestamp")).dateHistogramInterval(interval).format(timeFormat)).timeZone(DateTimeZone.forID((String)"+08:00"))).extendedBounds(extendedBounds);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).aggregation((AggregationBuilder)aggregation).size(size);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Histogram histogram = (Histogram)response.getAggregations().get("basicrRpm");
            ArrayList<String> timeList = new ArrayList<String>();
            ArrayList<Long> countList = new ArrayList<Long>();
            for (Histogram.Bucket apiEntry : histogram.getBuckets()) {
                String time = apiEntry.getKeyAsString();
                long apiCount = apiEntry.getDocCount();
                this.log.debug("time [{}], apiCount [{}], avgRespTime[{}]", (Object)time, (Object)apiCount);
                timeList.add(time);
                countList.add(apiCount);
            }
            resultMap.put("timeList", timeList);
            resultMap.put("countList", countList);
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6[{}={}]\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u9519\u8bef\u5217\u8868\u65f6\u62a5\u9519\uff1a{}", new Object[]{field, value, e.getMessage()});
        }
        return resultMap;
    }

    public Map queryApiDetailHitsList(String from, String to, int fromIndex, int size, String serviceName, String apiName, String orderType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            MatchQueryBuilder matchBuilder;
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            if (apiName.isEmpty() && serviceName.isEmpty()) {
                MatchAllQueryBuilder matchAllQueryBuilder = QueryBuilders.matchAllQuery();
                boolQueryBuilder.must((QueryBuilder)matchAllQueryBuilder);
            }
            if (!apiName.isEmpty()) {
                matchBuilder = QueryBuilders.matchQuery((String)"context.request.url.pathname", (Object)apiName);
                boolQueryBuilder.must((QueryBuilder)matchBuilder);
            }
            if (!serviceName.isEmpty()) {
                matchBuilder = QueryBuilders.matchQuery((String)"context.service.name", (Object)serviceName);
                boolQueryBuilder.must((QueryBuilder)matchBuilder);
            }
            FieldSortBuilder order = (FieldSortBuilder)SortBuilders.fieldSort((String)"@timestamp").order(SortOrder.DESC);
            if ("avgRespTime".equals(orderType)) {
                order = (FieldSortBuilder)SortBuilders.fieldSort((String)"transaction.duration.us").order(SortOrder.DESC);
            } else if ("errorCount".equals(orderType)) {
                order = (FieldSortBuilder)SortBuilders.fieldSort((String)"@timestamp").order(SortOrder.DESC);
                ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
                boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).from(fromIndex).size(size).sort((SortBuilder)order);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            SearchHits hit = response.getHits();
            resultMap.put("hits", hit.getHits());
            resultMap.put("total", hit.getTotalHits());
        }
        catch (IOException e) {
            this.log.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2api\u660e\u7ec6\u8be6\u60c5\u5217\u8868\uff1a{}", (Object)e.getMessage());
        }
        return resultMap;
    }

    public List<Map> apmBasicMetricsSearch(String timeFormat, String from, String to, DateHistogramInterval interval, int size) {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            ExtendedBounds extendedBounds;
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            try {
                extendedBounds = new ExtendedBounds(Long.valueOf(Long.parseLong(from)), Long.valueOf(Long.parseLong(to)));
            }
            catch (Exception e) {
                extendedBounds = new ExtendedBounds(from, to);
            }
            DateHistogramAggregationBuilder aggregation = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"basicrRpm").field("@timestamp")).dateHistogramInterval(interval).format(timeFormat)).timeZone(DateTimeZone.forID((String)"+08:00"))).extendedBounds(extendedBounds);
            TermsAggregationBuilder serviceAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName_term").field("context.service.name")).size(size);
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            serviceAggregation.subAggregation((AggregationBuilder)aggregation);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)rangequerybuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)serviceAggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms serviceBucket = (Terms)response.getAggregations().get("serviceName_term");
            for (Terms.Bucket entry : serviceBucket.getBuckets()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String serviceName = (String)entry.getKey();
                map.put("serviceName", serviceName);
                ArrayList<String> timelist = new ArrayList<String>();
                ArrayList<Long> countlist = new ArrayList<Long>();
                Histogram apiBucket = (Histogram)entry.getAggregations().get("basicrRpm");
                for (Histogram.Bucket apiEntry : apiBucket.getBuckets()) {
                    String time = apiEntry.getKeyAsString();
                    long apiCount = apiEntry.getDocCount();
                    this.log.debug("serviceName [{}], time [{}], apiCount [{}]", new Object[]{serviceName, time, apiCount});
                    timelist.add(time);
                    countlist.add(apiCount);
                }
                map.put("timeList", timelist);
                map.put("countList", countlist);
                list.add(map);
            }
        }
        catch (IOException e) {
            this.log.error("API\u76d1\u63a7\u6570\u636e\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return list;
    }

    public List<Map> apmBasicDetailSearch(String from, String to, int size, String orderType) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            ValuesSourceAggregationBuilder aggregationAvg = AggregationBuilders.avg((String)"avg_respTime").field("transaction.duration.us");
            ValuesSourceAggregationBuilder aggregationMax = AggregationBuilders.max((String)"max_respTime").field("transaction.duration.us");
            ValuesSourceAggregationBuilder aggregationMin = AggregationBuilders.min((String)"min_respTime").field("transaction.duration.us");
            PercentilesAggregationBuilder aggregationJw = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)"jw_avg_respTime").field("transaction.duration.us")).percentiles(new double[]{95.0});
            ValuesSourceAggregationBuilder aggregationError = AggregationBuilders.count((String)"error_count").field("error.id");
            TermsAggregationBuilder aggregation2 = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service_term").field("context.service.name")).size(size).subAggregation((AggregationBuilder)aggregationAvg)).subAggregation((AggregationBuilder)aggregationMin)).subAggregation((AggregationBuilder)aggregationMax)).subAggregation((AggregationBuilder)aggregationJw)).subAggregation((AggregationBuilder)aggregationError);
            BucketOrder order = BucketOrder.aggregation((String)"_count", (boolean)false);
            if ("avgRespTime".equals(orderType)) {
                order = BucketOrder.aggregation((String)"avg_respTime", (boolean)false);
            } else if ("reqCount".equals(orderType)) {
                order = BucketOrder.aggregation((String)"_count", (boolean)false);
            } else if ("errorCount".equals(orderType)) {
                order = BucketOrder.aggregation((String)"error_count", (boolean)false);
            }
            aggregation2.order(order);
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)rangequerybuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation2);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms serviceBucket = (Terms)response.getAggregations().get("service_term");
            for (Terms.Bucket apiEntry : serviceBucket.getBuckets()) {
                String serviceName = (String)apiEntry.getKey();
                HashMap<String, Object> map = new HashMap<String, Object>();
                long apiCount = apiEntry.getDocCount();
                Map subaggmap = apiEntry.getAggregations().asMap();
                double maxRespTime = ((ParsedMax)subaggmap.get("max_respTime")).getValue();
                double minRespTime = ((ParsedMin)subaggmap.get("min_respTime")).getValue();
                double avgRespTime = ((ParsedAvg)subaggmap.get("avg_respTime")).getValue();
                double jwAvgRespTime = 0.0;
                Percentiles percentiles = (Percentiles)subaggmap.get("jw_avg_respTime");
                for (Percentile entry : percentiles) {
                    jwAvgRespTime = entry.getValue();
                    map.put("jwAvgRespTime", jwAvgRespTime);
                }
                double errorCount = ((ParsedValueCount)subaggmap.get("error_count")).getValue();
                this.log.debug("serviceName [{}],  maxRespTime [{}], minRespTime[{}], avgRespTime[{}], jwAvgRespTime[{}], errorCount[{}]", new Object[]{serviceName, maxRespTime, minRespTime, avgRespTime, jwAvgRespTime, errorCount});
                map.put("serviceName", serviceName);
                map.put("apiCount", apiCount);
                map.put("maxRespTime", maxRespTime);
                map.put("minRespTime", minRespTime);
                map.put("avgRespTime", avgRespTime);
                map.put("errorCount", errorCount);
                resultList.add(map);
            }
        }
        catch (IOException e) {
            this.log.error("API\u76d1\u63a7\u6570\u636e\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return resultList;
    }

    public List<Map> apmRespTimeDetailSearch(String from, String to, int size, String orderType, String nodeIp, String serviceName, String timeThreshold) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            ValuesSourceAggregationBuilder aggregationAvg = AggregationBuilders.avg((String)"avg_respTime").field("transaction.duration.us");
            ValuesSourceAggregationBuilder aggregationMax = AggregationBuilders.max((String)"max_respTime").field("transaction.duration.us");
            ValuesSourceAggregationBuilder aggregationMin = AggregationBuilders.min((String)"min_respTime").field("transaction.duration.us");
            PercentilesAggregationBuilder aggregationJw = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)"jw_avg_respTime").field("transaction.duration.us")).percentiles(new double[]{95.0});
            ValuesSourceAggregationBuilder aggregationError = AggregationBuilders.count((String)"error_count").field("error.id");
            TermsAggregationBuilder aggregationService = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service_term").field("context.service.name")).size(size).subAggregation((AggregationBuilder)aggregationAvg)).subAggregation((AggregationBuilder)aggregationMin)).subAggregation((AggregationBuilder)aggregationMax)).subAggregation((AggregationBuilder)aggregationJw)).subAggregation((AggregationBuilder)aggregationError);
            TermsAggregationBuilder aggregationNode = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"node_term").field("beat.hostname")).size(size).subAggregation((AggregationBuilder)aggregationAvg)).subAggregation((AggregationBuilder)aggregationMin)).subAggregation((AggregationBuilder)aggregationMax)).subAggregation((AggregationBuilder)aggregationJw)).subAggregation((AggregationBuilder)aggregationError);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            if (nodeIp.isEmpty() && serviceName.isEmpty()) {
                MatchAllQueryBuilder matchAllQueryBuilder = QueryBuilders.matchAllQuery();
                boolQueryBuilder.must((QueryBuilder)matchAllQueryBuilder);
            }
            if (!nodeIp.isEmpty()) {
                nodeIp = "*" + nodeIp + "*";
                WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)"beat.hostname", (String)nodeIp);
                boolQueryBuilder.must((QueryBuilder)wildcardQueryBuilder);
            }
            if (!serviceName.isEmpty()) {
                MatchQueryBuilder matchBuilder = QueryBuilders.matchQuery((String)"context.service.name", (Object)serviceName);
                boolQueryBuilder.must((QueryBuilder)matchBuilder);
            }
            BucketOrder order = BucketOrder.aggregation((String)"_count", (boolean)false);
            if ("avgRespTime".equals(orderType)) {
                order = BucketOrder.aggregation((String)"avg_respTime", (boolean)false);
            } else if ("reqCount".equals(orderType)) {
                order = BucketOrder.aggregation((String)"_count", (boolean)false);
            } else if ("errorCount".equals(orderType)) {
                order = BucketOrder.aggregation((String)"error_count", (boolean)false);
                ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
                boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            }
            aggregationService.order(order);
            aggregationNode.order(order);
            aggregationService.subAggregation((AggregationBuilder)aggregationNode);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregationService);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms serviceBucket = (Terms)response.getAggregations().get("service_term");
            for (Terms.Bucket serviceEntry : serviceBucket.getBuckets()) {
                String tempServiceName = (String)serviceEntry.getKey();
                Terms nodeBucket = (Terms)serviceEntry.getAggregations().get("node_term");
                for (Terms.Bucket nodeEntry : nodeBucket.getBuckets()) {
                    int timethreshold;
                    String tempNodeIp = (String)nodeEntry.getKey();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    long apiCount = nodeEntry.getDocCount();
                    Map subaggmap = nodeEntry.getAggregations().asMap();
                    double maxRespTime = ((ParsedMax)subaggmap.get("max_respTime")).getValue();
                    double minRespTime = ((ParsedMin)subaggmap.get("min_respTime")).getValue();
                    double avgRespTime = ((ParsedAvg)subaggmap.get("avg_respTime")).getValue();
                    double jwAvgRespTime = 0.0;
                    Percentiles percentiles = (Percentiles)subaggmap.get("jw_avg_respTime");
                    for (Percentile entry : percentiles) {
                        jwAvgRespTime = entry.getValue();
                    }
                    double errorCount = ((ParsedValueCount)subaggmap.get("error_count")).getValue();
                    this.log.debug("serviceName [{}], nodeIp[{}], maxRespTime [{}], minRespTime[{}], avgRespTime[{}], jwAvgRespTime[{}], errorCount[{}]", new Object[]{tempServiceName, tempNodeIp, maxRespTime, minRespTime, avgRespTime, jwAvgRespTime, errorCount});
                    if ("".equals(timeThreshold)) {
                        timeThreshold = "0";
                    }
                    if ((timethreshold = Integer.parseInt(timeThreshold)) > 0 && avgRespTime / 1000.0 < (double)timethreshold) continue;
                    map.put("serviceName", tempServiceName);
                    map.put("nodeIp", tempNodeIp);
                    map.put("apiCount", apiCount);
                    map.put("maxRespTime", maxRespTime);
                    map.put("minRespTime", minRespTime);
                    map.put("avgRespTime", avgRespTime);
                    map.put("errorCount", errorCount);
                    map.put("jwAvgRespTime", jwAvgRespTime);
                    resultList.add(map);
                }
            }
        }
        catch (IOException e) {
            this.log.error("API\u76d1\u63a7\u6570\u636e\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return resultList;
    }

    public List<Map> apmErrorDetailSearch(String serviceName, String from, String to, int size) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"apm-*"});
            searchRequest.types(new String[]{"doc"});
            TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"api_term").field("context.request.url.pathname")).order(BucketOrder.aggregation((String)"_count", (boolean)false)).size(size);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"@timestamp").from((Object)from).to((Object)to);
            ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"error");
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"context.service.name", (Object)serviceName);
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
            boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
            boolQueryBuilder.must((QueryBuilder)matchQueryBuilder);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
            searchSourceBuilder.size(0);
            searchRequest.source(searchSourceBuilder);
            SearchResponse response = this.restClient.search(searchRequest, new Header[0]);
            Terms serviceBucket = (Terms)response.getAggregations().get("api_term");
            for (Terms.Bucket entry : serviceBucket.getBuckets()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String apiName = (String)entry.getKey();
                long count = entry.getDocCount();
                map.put("serviceName", serviceName);
                map.put("apiName", apiName);
                map.put("errorCount", count);
                resultList.add(map);
            }
        }
        catch (IOException e) {
            this.log.error("APM\u76d1\u63a7\u5fae\u670d\u52a1\u9519\u8bef\u63a5\u53e3\u8c03\u7528\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return resultList;
    }

    public Map saveApiConfigData(String index, String type, String id, String data) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            GetRequest getRequest = new GetRequest(index, type, id);
            Boolean isExist = this.restClient.exists(getRequest, RequestOptions.DEFAULT);
            BulkRequest request = new BulkRequest();
            if (isExist.booleanValue()) {
                request.add(new UpdateRequest(index, type, id).doc(XContentType.JSON, new Object[]{"data", data}));
            } else {
                request.add(new IndexRequest(index, type, id).source(XContentType.JSON, new Object[]{"data", data}));
            }
            BulkResponse bulkResponse = this.restClient.bulk(request, RequestOptions.DEFAULT);
            for (BulkItemResponse bulkItemResponse : bulkResponse) {
                if (!bulkItemResponse.isFailed()) continue;
                map.put("type", "error");
                map.put("message", "\u4fdd\u5b58\u5931\u8d25\uff01");
                break;
            }
            map.put("type", "success");
            map.put("message", "\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (IOException e) {
            this.log.error("\u4fdd\u5b58\u81ea\u5b9a\u4e49api\u76d1\u63a7\u914d\u7f6e\u5230ES\u65f6\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return map;
    }

    public Map searchApiConfigData(String index, String type, String id) {
        Map map = new HashMap();
        try {
            GetRequest getRequest = new GetRequest(index, type, id);
            GetResponse getResponse = this.restClient.get(getRequest, RequestOptions.DEFAULT);
            map = getResponse.getSourceAsMap();
        }
        catch (IOException e) {
            this.log.error("\u67e5\u8be2\u81ea\u5b9a\u4e49api\u76d1\u63a7\u914d\u7f6e\u5230ES\u65f6\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        return map;
    }
}

