### 客户端api列表
1. 根据系统id或者客户端id进行条件查询:
    1. api: /api/auth/clientsbyid
    2. 方式：GET
    3. 输入：
        ```
        {
            clientId:可以为空
            systemId:可以为空
        }
        ```
    4. 输出：
        ```
        {
            data:[{
              clientId:
              clientDesc:
              systemId:
            }],
            code:
            message:
        }
        ```
2. 获取客户端授权服务列表
    1. api：/api/auth/resource/auth/{clientId}
    2. 方式：GET
    3. 输入：clientId:路径变量（不能为空)
    4. 输出：
        ```
        {
            code:
            message:
            data:[{
            serviceId：
            serviceName:
            serviceUri:
            method:
            available:
            }]
        }
        ```
3. 批量删除某个客户端的授权服务
    1. api：/api/auth/resource/delete
    2. 方式：GET
    3. 输入：
        ```
        {
            clientId:必输
            resIds:必输，服务id以","分隔
        }
        ```
    4. 输出:
        ```
        {
            code:
            message:
            data:null
        }
        ```
4. 给某一个客户端进行服务授权
    1. api: /api/auth/client/authres
    2. 方式：GET
    3. 输入：
        ```
        {
            clientId:必输
            resIds:必输，服务id以","分隔
        }
        ```
    4. 输出:
        ```
        {
            code:
            message:
            data:null
        }
        ``` 
5. 查询客户端未授权服务列表
    1. api：/api/auth/resource/unauth/{clientId}
    2. 方式：GET
    3. 输入：clientId:路径变量（不能为空)
    4. 输出:
        ```
        {
            code:
            message:
            data:[{
                serviceId：
                serviceName:
                serviceUri:
                method:
                available:
            }]
        }
        ```
6. 根据服务名获取对应服务
    1. api：/api/auth/resourcebyname
    2. 方式：GET
    3. 输入：
        ```
        {
            serviceName:服务名，可以为空
        }
        ```
    4. 输出:
        ````
        {
            code:
            message:
            data:[{
              serviceId：
              serviceName:
              serviceUri:
              method:
              available:
              isWhite:
              gatewayEnable:
            }]
        }
7. 获取服务授权客户端：
    1. api：/api/auth/clientsbyres
    2. 方式：GET
    3. 输入：
        ```
        {
            serviceId:
        }
        ```
    4. 输出：
        ````
        {
            data:[{
              clientId:
              clientDesc:
              systemId:
            }],
            code:
            message:
        }
8. 服务注册
    1. api：/api/auth/res/register
    2. 方式：POST
    3. 输入:
        ```
        {
            serviceId：默认为空
            serviceName：
            serviceUri：
            method：
            available：
            isWhite:
            gatewayEnable:
            creator:
            updateUser:
        }
        ```
    4. 输出：
        ````
        {
            code:
            message:
        }
9. 服务变更
    1. api：/api/auth/res/update
    2. 方式：POST
    3. 输入:
        ```
        {
            serviceId：默认为空
            serviceName：
            serviceUri：
            method：
            available：
            isWhite:
            gatewayEnable:
            updateUser:
        }
        ```
    4. 输出：
        ````
        {
            code:
            message:
        } 
    


