/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.middleware.service;

import cn.com.yusys.yusp.control.middleware.domain.DeployTask;
import cn.com.yusys.yusp.control.middleware.domain.MiddleWare;
import cn.com.yusys.yusp.control.middleware.domain.MiddleWareInfo;
import cn.com.yusys.yusp.control.middleware.repository.DeployTaskRepository;
import cn.com.yusys.yusp.control.middleware.repository.MiddleWareInfoRepository;
import cn.com.yusys.yusp.control.middleware.repository.MiddleWareRepository;
import cn.com.yusys.yusp.control.middleware.service.DeployTaskService;
import cn.com.yusys.yusp.control.middleware.utils.MiddleWareConstants;
import cn.com.yusys.yusp.msm.common.DashboardCmdPair;
import cn.com.yusys.yusp.registry.host.repository.HostRepository;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MiddleWareDeployService {
    @Autowired
    private HostRepository hostRepository;
    @Autowired
    private DeployTaskRepository deployTaskRepository;
    @Autowired
    private DeployTaskService deployTaskService;
    @Autowired
    private MiddleWareRepository middleWareRepository;
    @Autowired
    private MiddleWareConstants middleWareConstants;
    @Autowired
    private MiddleWareInfoRepository middleWareInfoRepository;

    public void deploy(final String userId, List<String> ids, List<String> names, List<String> versions, List<String> startConfigs, List<String> hostNames) throws Exception {
        int i;
        final String basePath = this.middleWareConstants.getTargetBasePath();
        ExecutorService pool = Executors.newFixedThreadPool(5);
        ExecutorCompletionService<DeployTask> completionService = new ExecutorCompletionService<DeployTask>(pool);
        for (i = 0; i < names.size(); ++i) {
            final MiddleWare middleWare = this.middleWareRepository.getMiddleWare(names.get(i), versions.get(i));
            final String hostName = hostNames.get(i);
            final String startConfig = startConfigs.get(i);
            final String id = ids.get(i);
            this.deployTaskRepository.addDeployTask(new DeployTask(id, userId, hostName, middleWare.getName(), middleWare.getVersion(), startConfig, 1, "", "\u8bf7\u7a0d\u540e"));
            completionService.submit(new Callable<DeployTask>(){

                @Override
                public DeployTask call() throws Exception {
                    String pid;
                    block4: {
                        pid = "";
                        try {
                            if (!MiddleWareDeployService.this.deployTaskService.getMiddleWareStatus(middleWare.getName(), hostName)) {
                                MiddleWareDeployService.this.hostRepository.upload(hostName, new File(middleWare.getLocalFile()), basePath, true);
                                String startFile = middleWare.getStartFile();
                                String path = startFile.substring(0, startFile.lastIndexOf("/") + 1);
                                String file = "./" + startFile.substring(startFile.lastIndexOf("/") + 1, startFile.length());
                                String cmd = basePath + "deploy.sh " + middleWare.getName() + " " + middleWare.getFileName() + " " + middleWare.getOriginName() + " " + path + " " + file + " " + startConfig;
                                DashboardCmdPair result = MiddleWareDeployService.this.hostRepository.goCmd(hostName, "", cmd);
                                pid = result.getOut().replace("\n", "");
                                if (result.getOut().contains("err")) {
                                    return new DeployTask(id, userId, hostName, middleWare.getName(), middleWare.getVersion(), startConfig, -1, "", result.getOut());
                                }
                                break block4;
                            }
                            return new DeployTask(id, userId, hostName, middleWare.getName(), middleWare.getVersion(), startConfig, -1, "", "\u4e2d\u95f4\u4ef6\u5df2\u5b58\u5728");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return new DeployTask(id, userId, hostName, middleWare.getName(), middleWare.getVersion(), startConfig, -1, "", e.getMessage());
                        }
                    }
                    return new DeployTask(id, userId, hostName, middleWare.getName(), middleWare.getVersion(), startConfig, 2, pid, "success");
                }
            });
        }
        for (i = 0; i < names.size(); ++i) {
            DeployTask task = null;
            try {
                task = (DeployTask)completionService.poll(300L, TimeUnit.SECONDS).get();
            }
            catch (Exception e) {
                e.getStackTrace();
            }
            if (task == null) continue;
            this.deployTaskRepository.addDeployTask(task);
            if (task.getFlag() != 2) continue;
            this.middleWareInfoRepository.addInfo(new MiddleWareInfo(UUID.randomUUID().toString(), task.getId(), userId, task.getMiddleWareName(), task.getMiddleWareVersion(), task.getHostName(), task.getStartConfig(), task.getPid(), 1, task.getCreatedTime()));
        }
    }
}

