/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.middleware.resource;

import cn.com.yusys.yusp.control.middleware.domain.MiddleWare;
import cn.com.yusys.yusp.control.middleware.service.MiddleWareService;
import cn.com.yusys.yusp.control.middleware.utils.MiddleWareConstants;
import cn.com.yusys.yusp.msm.common.ResultDto;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/middleware"})
public class MiddleWareResource {
    private static final Logger logger = LoggerFactory.getLogger(MiddleWareResource.class);
    @Autowired
    private MiddleWareService service;
    @Autowired
    private MiddleWareConstants middleWareConstants;

    @GetMapping(value={"/list"})
    public ResultDto<List<MiddleWare>> getMiddleWareList() {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/middleware/list \u67e5\u8be2\u4e2d\u95f4\u4ef6\u5217\u8868");
        List<MiddleWare> list = null;
        try {
            list = this.service.getMiddleWareList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/version"})
    public ResultDto<List<String>> getMiddleWareVersion(@RequestParam(value="name") String name) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/middleware/ \u67e5\u8be2\u4e2d\u95f4\u4ef6\uff0c\u8bf7\u6c42\u53c2\u6570 name\uff1a" + name);
        List<String> list = null;
        try {
            list = this.service.getMiddleWareVersion(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto(list);
    }

    @GetMapping(value={"/names"})
    public ResultDto<List<String>> getMiddleWareNames() {
        List<String> list = null;
        try {
            list = this.service.getMiddleWareNameList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto(list);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addMiddleWare(@Valid MiddleWare middleWare, @RequestParam(value="file") MultipartFile file) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/middleware/ \u6dfb\u52a0\u4e2d\u95f4\u4ef6\uff0c\u8bf7\u6c42\u53c2\u6570 middleware\uff1a" + middleWare + ",file: " + file.getOriginalFilename());
        if (!file.isEmpty()) {
            if (this.middleWareConstants.getStartPath(middleWare.getName()) == null) {
                return new ResultDto(-1, 0L, "\u4e0d\u652f\u6301\u8be5\u4e2d\u95f4\u4ef6", null);
            }
            middleWare.setOriginName(file.getOriginalFilename());
            String filePath = "";
            if (file.getOriginalFilename().indexOf(".tar.gz") >= 0) {
                filePath = file.getOriginalFilename().substring(0, file.getOriginalFilename().indexOf(".tar.gz")) + "/";
            } else if (file.getOriginalFilename().indexOf(".tar") >= 0) {
                filePath = file.getOriginalFilename().substring(0, file.getOriginalFilename().indexOf(".tar")) + "/";
            } else if (file.getOriginalFilename().indexOf(".zip") >= 0) {
                filePath = file.getOriginalFilename().substring(0, file.getOriginalFilename().indexOf(".zip")) + "/";
            }
            middleWare.setFileName(filePath.split("/")[0]);
            String localPath = this.middleWareConstants.getLocalBasePath() + middleWare.getName() + "/" + file.getOriginalFilename();
            String configPath = filePath + this.middleWareConstants.getConfigPath(middleWare.getName());
            middleWare.setLocalFile(localPath);
            middleWare.setConfigFile(configPath);
            middleWare.setStartFile(filePath + this.middleWareConstants.getStartPath(middleWare.getName()));
            middleWare.setEndFile(filePath + this.middleWareConstants.getEndPath(middleWare.getName()));
            File file2 = new File(localPath);
            if (!file2.getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            try {
                file.transferTo(file2);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ResultDto(-1, 0L, e.getMessage(), null);
            }
        } else {
            return new ResultDto(-1, 0L, "\u5fc5\u987b\u6709\u4e2d\u95f4\u4ef6\u6587\u4ef6\uff01", null);
        }
        if (middleWare.getId() == null || middleWare.getId().equals("")) {
            middleWare.setId(UUID.randomUUID().toString());
        }
        try {
            this.service.addMiddleWare(middleWare);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delMiddleWare(@PathVariable(value="ids") String ids) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/middleware/ \u5220\u9664\u4e2d\u95f4\u4ef6\uff0c\u8bf7\u6c42\u53c2\u6570 id\uff1a" + ids);
        try {
            this.service.delMiddleWare(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

