/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.jenkins.service.impl;

import cn.com.yusys.yusp.commons.exception.YuspException;
import cn.com.yusys.yusp.control.jenkins.domain.JenkinsBuildDomain;
import cn.com.yusys.yusp.control.jenkins.service.JenkinsBuildService;
import cn.com.yusys.yusp.control.repository.mapper.JenkinsBuildMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.JobWithDetails;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class JenkinsBuildServiceDBImpl
implements JenkinsBuildService {
    private final Logger logger = LoggerFactory.getLogger(JenkinsBuildServiceDBImpl.class);
    @Autowired
    private JenkinsBuildMapper jenkinsBuildMapper;
    @Value(value="${jenkins.url}")
    private String jenkinsUrl;
    @Value(value="${jenkins.userName}")
    private String userName;
    @Value(value="${jenkins.password}")
    private String password;
    private final String SUCCESS = "SUCCESS";
    private final String FAILURE = "FAILURE";
    private final String UNSTABLE = "UNSTABLE";

    @Override
    public JenkinsServer jenkinsServer() {
        JenkinsServer jenkins = null;
        try {
            jenkins = new JenkinsServer(new URI(this.jenkinsUrl), this.userName, this.password);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jenkins;
    }

    @Override
    public String jobCheck(String jenkinsBuildName) {
        JenkinsServer server = this.jenkinsServer();
        if (null != server) {
            try {
                JobWithDetails job = server.getJob(jenkinsBuildName);
                if (job == null) {
                    throw new YuspException("warning", "900000", "Jenkins\u4e0a\u65e0\u8be5\u5e94\u7528\u7684\u6784\u5efa\u4efb\u52a1,\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u586b\u5199\u8be5\u5e94\u7528\u7684Jenkins\u914d\u7f6e\u540d\u79f0!", new Object[0]);
                }
                return "SUCCESS";
            }
            catch (IOException e) {
                throw new YuspException("error", "900000", "Jenkins\u65e0\u6cd5\u8bbf\u95ee,\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u914d\u7f6e\u5730\u5740\u4fe1\u606f!", new Object[0]);
            }
        }
        return "FAILURE";
    }

    @Override
    public Map<String, Object> jobBuild(String jenkinsBuildName, String serviceName) {
        Map<String, Object> result = new HashMap<String, Object>();
        JenkinsServer server = this.jenkinsServer();
        int buildNumber = 0;
        if (null != server) {
            try {
                JobWithDetails job = server.getJob(jenkinsBuildName);
                buildNumber = job.getNextBuildNumber();
                try {
                    job.build(job.getLastBuild().details().getParameters(), true);
                }
                catch (Exception e) {
                    job.build(true);
                }
                this.saveBuildInfo(serviceName, buildNumber, "0");
                result = this.bulidDetails(jenkinsBuildName, buildNumber, serviceName);
                this.logger.info("\u5e94\u7528{}\u6784\u5efa\u7ed3\u675f\uff0c\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)serviceName, result.get("buildResult"));
                LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u5e94\u7528{}\u6784\u5efa\u7ed3\u675f\uff0c\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object[])new Object[]{serviceName, result.get("buildResult")});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public BuildWithDetails buildResult(String jenkinsBuildName, int buildNumber) {
        JenkinsServer server = this.jenkinsServer();
        BuildWithDetails buildDetails = null;
        if (null != server) {
            try {
                JobWithDetails job = server.getJob(jenkinsBuildName);
                JobWithDetails details = job.details();
                Build buildByNumber = details.getBuildByNumber(buildNumber);
                if (buildByNumber != null) {
                    buildDetails = buildByNumber.details();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buildDetails;
    }

    @Override
    public Map<String, Object> bulidDetails(String jenkinsBuildName, int buildNumber, String serviceName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BuildWithDetails details = null;
        Boolean flag = false;
        while (!flag.booleanValue()) {
            details = this.buildResult(jenkinsBuildName, buildNumber);
            if (null != details && null != details.getResult() && ("SUCCESS".equals(details.getResult().toString()) || "FAILURE".equals(details.getResult().toString()) || "UNSTABLE".equals(details.getResult().toString()))) {
                flag = true;
                break;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (null != details) {
            result.put("buildNumber", buildNumber);
            result.put("fullDisplayName", details.getFullDisplayName());
            result.put("buildResult", details.getResult());
            result.put("timestamp", details.getTimestamp());
            result.put("duration", details.getDuration());
            result.put("estimatedDuration", details.getEstimatedDuration());
            this.saveBuildInfo(serviceName, buildNumber, "-1");
        }
        return result;
    }

    @Override
    public String consoleInfo(String jenkinsBuildName, int buildNumber) throws IOException {
        BuildWithDetails details = this.buildResult(jenkinsBuildName, buildNumber);
        if (null != details) {
            return details.getConsoleOutputText();
        }
        return null;
    }

    @Override
    public List<JenkinsBuildDomain> getJenkinsInfo() {
        return this.jenkinsBuildMapper.getBuildInfo();
    }

    @Override
    public void saveBuildInfo(String serviceName, int buildNumber, String buildFlag) {
        JenkinsBuildDomain domain = new JenkinsBuildDomain();
        domain.setName(serviceName);
        domain.setBuildNumber(buildNumber);
        domain.setBuildFlag(buildFlag);
        if (this.getJenkinsInfo().stream().noneMatch(j -> serviceName.equals(j.getName()))) {
            this.jenkinsBuildMapper.addBuildInfo(domain);
        } else {
            this.jenkinsBuildMapper.updateBulidInfo(domain);
        }
        this.logger.info("\u4fdd\u5b58\u5e94\u7528{}\u7684\u6784\u5efa\u72b6\u6001\uff0c\u5f53\u524d\u4e3a{}", (Object)serviceName, (Object)(buildFlag == "0" ? "\u6784\u5efa\u4e2d" : "\u6784\u5efa\u7ed3\u675f"));
    }

    public static void main(String[] args) {
        String url = "http://192.168.254.128:8081/jenkins/";
        String job = "M-yusp-app-common";
        try {
            JenkinsServer server = new JenkinsServer(new URI(url), "yusp", "yusp");
            JobWithDetails jobWithDetails = server.getJob(job);
            Build build = jobWithDetails.getLastBuild();
            System.out.println(build.getUrl());
            BuildWithDetails details = build.details();
            System.out.println(details.getFullDisplayName());
            System.out.println(details.getResult());
            System.out.println(details.getTimestamp() + ":" + details.getDuration());
            System.out.println(details.getParameters());
            jobWithDetails.getNextBuildNumber();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

