/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.web.rest.util;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class HeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(HeaderUtil.class);
    private static final String APPLICATION_NAME = "yuspDashboardApp";
    public static final String AUTHORIZATION = "Authorization";

    private HeaderUtil() {
    }

    public static HttpHeaders createAlert(String message, String param) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-yuspDashboardApp-alert", message);
        headers.add("X-yuspDashboardApp-params", param);
        return headers;
    }

    public static HttpHeaders createEntityCreationAlert(String entityName, String param) {
        return HeaderUtil.createAlert("yuspDashboardApp." + entityName + ".created", param);
    }

    public static HttpHeaders createEntityUpdateAlert(String entityName, String param) {
        return HeaderUtil.createAlert("yuspDashboardApp." + entityName + ".updated", param);
    }

    public static HttpHeaders createEntityDeletionAlert(String entityName, String param) {
        return HeaderUtil.createAlert("yuspDashboardApp." + entityName + ".deleted", param);
    }

    public static HttpHeaders createFailureAlert(String entityName, String errorKey, String defaultMessage) {
        log.error("Entity creation failed, {}", (Object)defaultMessage);
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-yuspDashboardApp-error", "error." + errorKey);
        headers.add("X-yuspDashboardApp-params", entityName);
        return headers;
    }

    public static String getAccessToken() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return request.getHeader(AUTHORIZATION);
    }
}

