/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.web.rest;

import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.resource.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/service/basic"})
public class ServiceInfoResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInfoResource.class);

    ServiceInfoService getService() {
        return (ServiceInfoService)this.getService(ServiceInfoService.class);
    }

    @GetMapping(value={"/info"})
    public ResultDto<List<ServiceInfoDomain>> getServiceInfos(@RequestParam(required=false) String condition) {
        List<ServiceInfoDomain> serviceInfoDomains = this.getService().getServicesInfo();
        if (!StringUtils.isEmpty((Object)condition)) {
            return this.getServiceInfoListByCondition(serviceInfoDomains, condition);
        }
        return new ResultDto((long)serviceInfoDomains.size(), serviceInfoDomains);
    }

    public ResultDto<List<ServiceInfoDomain>> getServiceInfoListByCondition(List<ServiceInfoDomain> serviceInfoDomains, String condition) {
        logger.info("=============>\u670d\u52a1\u4fe1\u606f\u67e5\u8be2\u6761\u4ef6\u4e3a: {}", (Object)condition);
        JSONObject conditionObj = JSONObject.fromObject((Object)condition);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        Set keySet = conditionObj.keySet();
        for (String key : keySet) {
            if (StringUtils.isEmpty((Object)conditionObj.getString(key))) continue;
            queryMap.put(key, conditionObj.getString(key));
        }
        if (queryMap.containsKey("serviceName")) {
            serviceInfoDomains = serviceInfoDomains.stream().filter(serviceInfoDomain -> serviceInfoDomain.getName().contains(((String)queryMap.get("serviceName")).toUpperCase())).collect(Collectors.toList());
        }
        if (queryMap.containsKey("businessDomain")) {
            serviceInfoDomains = serviceInfoDomains.stream().filter(serviceInfoDomain -> (serviceInfoDomain.getBusinessDomain() == null ? "" : serviceInfoDomain.getBusinessDomain()).contains((CharSequence)queryMap.get("businessDomain"))).collect(Collectors.toList());
        }
        if (queryMap.containsKey("dutyTeam")) {
            serviceInfoDomains = serviceInfoDomains.stream().filter(serviceInfoDomain -> (serviceInfoDomain.getDutyTeam() == null ? "" : serviceInfoDomain.getDutyTeam()).contains((CharSequence)queryMap.get("dutyTeam"))).collect(Collectors.toList());
        }
        return new ResultDto((long)serviceInfoDomains.size(), serviceInfoDomains);
    }

    @GetMapping(value={"/info/{name}"})
    public ResultDto<List<ServiceInfoDomain>> getServicesInfoByName(@PathVariable String name, @RequestParam(required=false) String condition) {
        if (name.length() == 36) {
            logger.info("\u6839\u636e\u96c6\u7fa4id\u67e5\u8be2\u670d\u52a1\u5217\u8868\uff0c\u96c6\u7fa4id\uff1a {}", (Object)name);
            List<ServiceInfoDomain> serviceInfoDomainList = this.getService().getServiceInfoListByCluster(name);
            if (!StringUtils.isEmpty((Object)condition)) {
                return this.getServiceInfoListByCondition(serviceInfoDomainList, condition);
            }
            return new ResultDto((long)serviceInfoDomainList.size(), serviceInfoDomainList);
        }
        logger.info("getServicesInfoByName by :{}", (Object)name);
        List<ServiceInfoDomain> serviceInfoDomains = this.getService().getServicesInfoByName(name);
        return new ResultDto((long)serviceInfoDomains.size(), serviceInfoDomains);
    }

    @GetMapping(value={"/version"})
    public ResultDto<Collection<VersionInfo>> getVersionByService() {
        ArrayList<VersionInfo> listVersionInfo = new ArrayList<VersionInfo>();
        for (ServiceInfoDomain serviceInfoDomain : this.getService().getServicesInfo()) {
            if (serviceInfoDomain.getVersionMap() == null) continue;
            listVersionInfo.addAll(serviceInfoDomain.getVersionMap().values());
        }
        return new ResultDto(listVersionInfo);
    }

    @GetMapping(value={"/version/{name}"})
    public ResultDto<Collection<VersionInfo>> getVersionByService(@PathVariable String name) {
        List<Object> listVersionInfo = new ArrayList();
        if (name.length() == 36) {
            logger.info("\u6839\u636e\u96c6\u7fa4id\u67e5\u8be2\u670d\u52a1\u7248\u672c\u5217\u8868\uff0c\u96c6\u7fa4id\uff1a {}", (Object)name);
            for (ServiceInfoDomain serviceInfoDomain : this.getService().getServiceInfoListByCluster(name)) {
                if (serviceInfoDomain.getVersionMap() == null) continue;
                listVersionInfo.addAll(serviceInfoDomain.getVersionMap().values());
            }
        } else {
            logger.info("\u6839\u636e\u670d\u52a1\u540d\u67e5\u8be2\u670d\u52a1\u7248\u672c\u5217\u8868 by :{}", (Object)name);
            listVersionInfo = this.getService().getServiceBasicInfo(name);
        }
        return new ResultDto(listVersionInfo);
    }

    @GetMapping(value={"/version/file/{name}"})
    public ResultDto<List<VersionInfo>> getFileByServiceName(@PathVariable String name) {
        logger.info("\u6839\u636e\u670d\u52a1\u540d\u67e5\u8be2\u670d\u52a1\u7248\u672c\u6587\u4ef6\u5217\u8868 by :{}", (Object)name);
        List<VersionInfo> list = this.getService().getFileByServiceName(name);
        Collections.reverse(list);
        return new ResultDto(list);
    }

    @GetMapping(value={"/version/remove"})
    public ResultDto<Integer> removeVersions(String serviceName, String fileList) {
        logger.info("\u8c03\u7528\u63a5\u53e3:/api/service/basic/version/remove;\u8bf7\u6c42\u53c2\u6570:name:{},key:{}", (Object)serviceName, (Object)fileList);
        int result = this.getService().removeVersion(serviceName, fileList);
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/namelist"})
    public ResultDto<List<Map<String, String>>> serviceNameList(@RequestParam(required=false) String clusterId) {
        logger.info("\u8c03\u7528\u63a5\u53e3:/api/service/basic/namelist;\u8bf7\u6c42\u53c2\u6570:clusterId(\u5141\u8bb8\u4e3a\u7a7a)");
        List<Map<String, String>> serviceNameList = this.getService().getServiceNameList(clusterId);
        return new ResultDto(serviceNameList);
    }

    @PostMapping(value={"/update"})
    public ResultDto<Integer> addService(@RequestBody @Valid ServiceInfoDomain infoDomain) {
        List<ServiceInfoDomain> serviceInfoDomains = this.getService().getServicesInfoByName(infoDomain.getName());
        if (StringUtils.isEmpty((Object)infoDomain.getId()) && serviceInfoDomains.size() > 0) {
            return new ResultDto(10000, 0L, "\u8be5\u670d\u52a1\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\uff01", (Object)0);
        }
        if (!StringUtils.isEmpty((Object)infoDomain.getJenkinsBuildName()) && this.getService().isJenkinsBuildNameExisted(infoDomain.getJenkinsBuildName(), infoDomain.getId())) {
            return new ResultDto(10000, 0L, "\u8be5Jenkins\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\uff01", (Object)0);
        }
        int result = this.getService().updateService(infoDomain);
        return new ResultDto((Object)result);
    }

    @PostMapping(value={"/updateExpandShrinkDetails"})
    public ResultDto<Integer> updateExpandShrinkDetails(String name, @RequestBody ServiceInfoDomain serviceInfoDomain) {
        serviceInfoDomain.setName(name);
        int result = this.getService().updateExpandShrinkDetails(serviceInfoDomain);
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<Integer> deleteService(@PathVariable String ids) {
        int result = this.getService().removeService(ids);
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/dependjars"})
    public ResultDto<String> getDependJars(String serviceName, String fileName) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u67e5\u770b\u670d\u52a1[{}]\u7684\u7248\u672c\u6587\u4ef6{}", (Object[])new Object[]{serviceName, fileName});
        return new ResultDto((Object)this.getService().getDependJar(serviceName, fileName));
    }

    @PostMapping(value={"/uploadfile"})
    public ResultDto<Integer> uploadFile(MultipartFile file, VersionInfo versionInfo) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u670d\u52a1[{}],\u4e0a\u4f20\u6587\u4ef6[{}]->\u7248\u672c\u53f7{}", (Object[])new Object[]{versionInfo.getName(), file.getOriginalFilename(), versionInfo.getVersion()});
        return new ResultDto((Object)this.getService().uploadFile(file, versionInfo));
    }

    @PostMapping(value={"/savenodeinfo"})
    public ResultDto<Integer> saveNodeInfo(@RequestBody String coordinate) {
        int result = this.getService().saveNodeInfo(coordinate);
        return new ResultDto((Object)result);
    }
}

