/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.web.rest;

import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.web.rest.util.HeaderUtil;
import cn.com.yusys.yusp.msm.common.ResultDto;
import javax.servlet.ServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/monitorservice"})
public class MonitorServiceResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorServiceResource.class);
    @Autowired
    private ApplicationRepository repository;
    @Autowired
    private HttpClient httpClient;

    @GetMapping(value={"/{ids}/{method}/"})
    public ResultDto<String> proxy(@PathVariable String ids, @PathVariable String method, ServletRequest request) {
        String result = "";
        if (ids != null && !"".equals(ids)) {
            String[] instanceIds = ids.split(",");
            for (int i = 0; i < instanceIds.length; ++i) {
                String managementUrl = this.repository.getInstanceManagementUrl(instanceIds[i]);
                try {
                    URIBuilder builder = new URIBuilder(managementUrl + "/" + method);
                    request.getParameterMap().forEach((key, value) -> builder.setParameter(key, value[0]));
                    HttpGet httpGet = new HttpGet(builder.build());
                    httpGet.setHeader("Authorization", HeaderUtil.getAccessToken());
                    HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
                    HttpEntity entity = response.getEntity();
                    result = result + "|" + EntityUtils.toString((HttpEntity)entity);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot proxy metrics to instance", (Throwable)e);
                }
            }
        }
        return new ResultDto((Object)result);
    }
}

