/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.web.rest;

import cn.com.yusys.yusp.control.governance.domain.Cluster;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.service.ClusterService;
import cn.com.yusys.yusp.control.governance.service.InstanceManagerService;
import cn.com.yusys.yusp.control.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.resource.Resource;
import cn.com.yusys.yusp.registry.host.service.HostService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cluster"})
public class ClusterResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(ClusterResource.class);

    ClusterService getClusterService() {
        return (ClusterService)this.getService(ClusterService.class);
    }

    HostService getHostService() {
        return (HostService)this.getService(HostService.class);
    }

    ServiceInfoService getService() {
        return (ServiceInfoService)this.getService(ServiceInfoService.class);
    }

    InstanceManagerService getInstanceManagerService() {
        return (InstanceManagerService)this.getService(InstanceManagerService.class);
    }

    @GetMapping(value={"/list"})
    public ResultDto<List<Cluster>> getClusterList() {
        logger.info("\u8bf7\u6c42\u63a5\u53e3: /api/cluster/list \u67e5\u8be2\u96c6\u7fa4\u5217\u8868");
        List<Cluster> clusterList = null;
        clusterList = this.getClusterService().getClusterList();
        return new ResultDto((long)clusterList.size(), clusterList);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addCluster(@RequestBody @Valid Cluster cluster) {
        int addClusterResult;
        logger.info("\u8bf7\u6c42\u63a5\u53e3: /api/cluster/ \u6dfb\u52a0\u96c6\u7fa4\uff0c\u8bf7\u6c42\u53c2\u6570 cluster: {}", (Object)cluster);
        if (cluster.getId() == null || cluster.getId().equals("")) {
            cluster.setId(UUID.randomUUID().toString());
        }
        if ((addClusterResult = this.getClusterService().addCluster(cluster)) == 1) {
            return new ResultDto((Object)"success");
        }
        if (addClusterResult == 0) {
            ResultDto dto = new ResultDto((Object)"error");
            dto.setMessage("\u96c6\u7fa4\u540d\u5df2\u5b58\u5728");
            return dto;
        }
        return new ResultDto((Object)"error");
    }

    @GetMapping(value={"/{clusterName}"})
    public ResultDto<Cluster> getClusterByName(@PathVariable String clusterName) {
        Cluster cluster = this.getClusterService().getClusterByClusterName(clusterName);
        return new ResultDto((Object)cluster);
    }

    @GetMapping(value={"/outline"})
    public ResultDto<Map<String, Integer>> getClusterOutline(@RequestParam(required=false) String cluster) {
        HashMap<String, Integer> clusterOutlineMap = new HashMap<String, Integer>();
        int hostCount = this.getHostService().getHostsByCluster(cluster).size();
        int registryCount = this.getService().getServiceInfoListByCluster(cluster).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ServiceInfoDomain>(Comparator.comparing(o -> o.getName()))), ArrayList::new)).size();
        int appCount = this.getInstanceManagerService().getApplicationListByCluster(cluster).size();
        int instanceCount = this.getInstanceManagerService().getInstanceListByCluster(cluster).size();
        clusterOutlineMap.put("hostCount", hostCount);
        clusterOutlineMap.put("registryCount", registryCount);
        clusterOutlineMap.put("appCount", appCount);
        clusterOutlineMap.put("instanceCount", instanceCount);
        return new ResultDto(clusterOutlineMap);
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delClusterByIds(@PathVariable(value="ids") String ids) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/cluster/delete/ \u5220\u9664\u96c6\u7fa4,\u8bf7\u6c42\u53c2\u6570ids: {}", (Object)ids);
        try {
            this.getClusterService().delClusterByIds(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

