/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.IndexDomain;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.executor.ServiceFlexTask;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.repository.ServiceInfoRepository;
import cn.com.yusys.yusp.control.governance.service.ServiceFlexService;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="file")
public class ServiceFlexServiceFileImpl
implements ServiceFlexService {
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private ServiceFlexTask task;

    @Override
    public List<ServiceInfoDomain> getServiceInfo() {
        Collection<Application> applications = this.applicationRepository.findAll();
        List<ServiceInfoDomain> serviceInfoDomains = this.serviceInfoRepository.getServiceInfos();
        ArrayList<ServiceInfoDomain> list0 = new ArrayList<ServiceInfoDomain>();
        for (int i = 0; i < serviceInfoDomains.size(); ++i) {
            ServiceInfoDomain domain = serviceInfoDomains.get(i);
            List<VersionInfo> list = this.serviceInfoRepository.getFileByServiceName(domain.getName());
            if (domain == null || list.size() == 0) continue;
            VersionInfo maxVersion = this.serviceInfoRepository.getMaxVersionByName(domain.getName());
            if (maxVersion != null) {
                HashMap<String, VersionInfo> map = new HashMap<String, VersionInfo>();
                map.put(maxVersion.getVersion(), maxVersion);
                domain.setVersionMap(map);
            }
            int instanceSize = 0;
            List application = applications.stream().filter(app -> StringUtils.equalsIgnoreCase((CharSequence)domain.getName(), (CharSequence)app.getName())).collect(Collectors.toList());
            if (application.size() > 0) {
                instanceSize = ((Application)application.get(0)).getInstances().size();
            }
            domain.setInstanceNum(instanceSize);
            domain.setClusterNum(instanceSize);
            list0.add(domain);
        }
        return list0;
    }

    @Override
    public ServiceInfoDomain getServiceByName(String name) {
        ServiceInfoDomain domain = null;
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Application application = this.applicationRepository.findByName(name);
            domain = this.serviceInfoRepository.getServiceInfoByName(name);
            if (domain != null) {
                if (application == null) {
                    domain.setInstanceNum(0);
                } else {
                    domain.setInstanceNum(application.getInstances().size());
                }
                domain.setClusterNum(domain.getInstanceNum());
            }
        }
        return domain;
    }

    @Override
    public List<IndexDomain> getIndexByName(String name) {
        List<IndexDomain> indexList = this.serviceInfoRepository.getIndexByName(name);
        for (int i = 0; i < indexList.size(); ++i) {
            indexList.set(i, this.loadMontiorValue(indexList.get(i)));
        }
        return indexList;
    }

    @Override
    public int updateIndexByName(String name, IndexDomain indexDomain) {
        indexDomain.setServiceName(name);
        int i = this.serviceInfoRepository.updateServiceIndex(name, indexDomain, true);
        return i;
    }

    @Override
    public int addIndex(String name, IndexDomain indexDomain) {
        indexDomain.setServiceName(name);
        int i = this.serviceInfoRepository.updateServiceIndex(name, indexDomain, true);
        return i;
    }

    @Override
    public int removeIndexByName(String name, String ids) {
        if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)ids)) {
            int i = this.serviceInfoRepository.removeServiceIndex(name, ids.split(","));
            return i;
        }
        return 1;
    }

    @Override
    public void updateInstance(String name, boolean expand, String host) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u521b\u5efa\u5f39\u6027\u4f38\u7f29\u8c03\u5ea6\u4efb\u52a1->\u6210\u529f", (Object[])new Object[0]);
        this.task.manualRun(name, expand, host);
    }

    @Override
    public IndexDomain loadMontiorValue(IndexDomain index) {
        return index;
    }

    @Override
    public HostDomain getRandomHost(String serviceName) {
        return null;
    }
}

