/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.Instance;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.install.DeployStatus;
import cn.com.yusys.yusp.control.governance.install.ServiceInstall;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.repository.eureka.RemoteEurekaRepository;
import cn.com.yusys.yusp.control.governance.service.InstanceManagerService;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallServiceDBMapper;
import cn.com.yusys.yusp.control.repository.mapper.InstanceManagerMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.registry.host.repository.mapper.HostServiceDBMapper;
import com.google.common.collect.Lists;
import com.netflix.appinfo.InstanceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class InstanceManagerServiceDBImpl
implements InstanceManagerService {
    private final Logger log = LoggerFactory.getLogger(InstanceManagerServiceDBImpl.class);
    @Autowired
    private InstanceManagerMapper instanceManagerMapper;
    @Autowired
    ApplicationInstallServiceDBMapper applicationInstallServiceDBMapper;
    @Autowired
    private ApplicationRepository repository;
    @Autowired
    private ServiceInstall serviceInstall;
    @Autowired
    private ServiceInfoMapper serviceInfoMapper;
    @Autowired
    private RemoteEurekaRepository remoteEurekaRepository;
    @Autowired
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private HostServiceDBMapper hostServiceDBMapper;
    private Map<String, ScheduledFuture<?>> scheduledFutureMap = new ConcurrentHashMap();
    private Map<String, String> sessionIdMap = new ConcurrentHashMap<String, String>();
    private Map<String, Map<String, String>> envMap = new ConcurrentHashMap<String, Map<String, String>>();
    private static final String TAIL_COMMAND = "tail -n 1 -f ";

    @Override
    public List<Instance> getList() {
        return this.instanceManagerMapper.getInstanceList();
    }

    @Override
    public int updateWeight(Instance instance) {
        ServiceInfoDomain serviceInfoDomain = this.serviceInfoMapper.getServiceInfoByName(instance.getId().split("@")[0]);
        instance.setServiceId(serviceInfoDomain != null ? serviceInfoDomain.getId() : null);
        if (this.instanceManagerMapper.findInstanceById(instance.getId()) == null) {
            return this.instanceManagerMapper.addInstance(instance);
        }
        return this.instanceManagerMapper.updateWeight(instance);
    }

    @Override
    public Collection<Application> loadConfigInfo(Collection<Application> applicationList) {
        List<Instance> instanceList = this.instanceManagerMapper.getInstanceList();
        for (Instance instance : instanceList) {
            String name = instance.getId().split("@")[0];
            List appListTmp = applicationList.stream().filter(a -> a.getName().equals(name)).collect(Collectors.toList());
            if (appListTmp.size() > 0) {
                List insTmp = ((Application)appListTmp.get(0)).getInstances().stream().filter(a -> a.getUrl().equals(instance.getUrl())).collect(Collectors.toList());
                if (insTmp.size() > 0) {
                    ((Instance)insTmp.get(0)).setWeighted(instance.getWeighted());
                    ((Instance)insTmp.get(0)).setLable(instance.getLable());
                    continue;
                }
                if (!instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) continue;
                instance.setStatus(InstanceInfo.InstanceStatus.UNKNOWN.name());
                continue;
            }
            if (!instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) continue;
            instance.setStatus(InstanceInfo.InstanceStatus.UNKNOWN.name());
        }
        return applicationList;
    }

    @Override
    public Application loadConfigInfo(Application application) {
        List<Instance> instanceList = this.instanceManagerMapper.getInstanceList();
        if (application == null) {
            return null;
        }
        for (Instance instance : instanceList) {
            String name = instance.getId().split("@")[0];
            if (!name.equals(application.getName())) continue;
            List insTmp = null;
            if (application.getInstances() != null) {
                insTmp = application.getInstances().stream().filter(a -> a.getUrl().equals(instance.getUrl())).collect(Collectors.toList());
            }
            if (insTmp != null && insTmp.size() > 0) {
                ((Instance)insTmp.get(0)).setWeighted(instance.getWeighted());
                ((Instance)insTmp.get(0)).setLable(instance.getLable());
                continue;
            }
            if (!instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) continue;
            instance.setStatus(InstanceInfo.InstanceStatus.UNKNOWN.name());
        }
        return application;
    }

    @Override
    public Collection<Application> loadDeployInfo(Collection<Application> applicationList) {
        List<DeployInfo> listDeploy = this.applicationInstallServiceDBMapper.getList();
        for (DeployInfo deployInfo : listDeploy) {
            if (deployInfo.getDeployNo() != DeployStatus.RUNNING.getStepNo()) continue;
            String name = deployInfo.getName();
            List appListTmp = applicationList.stream().filter(a -> a.getName().equals(name)).collect(Collectors.toList());
            if (appListTmp.size() > 0) {
                List instanceList = ((Application)appListTmp.get(0)).getInstances().stream().filter(a -> a.getIp().equals(deployInfo.getIp()) && a.getPort() == deployInfo.getPort()).collect(Collectors.toList());
                if (instanceList.size() != 0) continue;
                InstanceInfo instanceInfo = this.remoteEurekaRepository.findInstanceInfo(deployInfo.getName() + "@" + deployInfo.getIp() + ":" + deployInfo.getPort());
                if (instanceInfo != null && instanceInfo.getStatus() == InstanceInfo.InstanceStatus.DOWN) {
                    ((Application)appListTmp.get(0)).getInstances().add(this.buildInstanceInfo(deployInfo, DeployStatus.DOWN));
                    continue;
                }
                ((Application)appListTmp.get(0)).getInstances().add(this.buildInstanceInfo(deployInfo, DeployStatus.OFFLINE));
                continue;
            }
            applicationList.add(new Application(name, Lists.newArrayList((Object[])new Instance[]{this.buildInstanceInfo(deployInfo, DeployStatus.OFFLINE)})));
        }
        return applicationList;
    }

    @Override
    public Application loadDeployInfo(Application application) {
        List<DeployInfo> listDeploy = this.applicationInstallServiceDBMapper.getList();
        for (DeployInfo deployInfo : listDeploy) {
            List instanceList;
            String name = deployInfo.getName();
            if (deployInfo.getDeployNo() != DeployStatus.RUNNING.getStepNo() || !name.equals(application.getName()) || (instanceList = application.getInstances().stream().filter(a -> a.getIp().equals(deployInfo.getIp()) && a.getPort() == deployInfo.getPort()).collect(Collectors.toList())).size() != 0) continue;
            application.getInstances().add(this.buildInstanceInfo(deployInfo, DeployStatus.OFFLINE));
        }
        return application;
    }

    private Instance buildInstanceInfo(DeployInfo deployInfo, DeployStatus deployStatus) {
        Instance instance = new Instance();
        instance.setName(deployInfo.getIp() + ":" + deployInfo.getPort());
        instance.setId(deployInfo.getName() + "@" + deployInfo.getIp() + ":" + deployInfo.getPort());
        instance.setServiceId(deployInfo.getName());
        instance.setIp(deployInfo.getIp());
        instance.setPort(deployInfo.getPort());
        instance.setStatus(deployStatus.name());
        instance.setUrl("http://" + deployInfo.getIp() + ":" + deployInfo.getPort());
        instance.setVersion(deployInfo.getVersion());
        instance.setDeployNo(deployInfo.getDeployNo());
        instance.setDeployDesc(deployInfo.getDeployDesc());
        return instance;
    }

    @Override
    public Collection<Instance> findInstanceList(String name) {
        this.log.debug("findInstanceList Instances with name= {}", (Object)name);
        Collection<Application> applicationList = this.findAll(name);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    @Override
    public Collection<Application> findAll(String name) {
        ArrayList applicationList;
        this.log.debug("findAll Application with name= {}", (Object)name);
        if (StringUtils.isEmpty((CharSequence)name)) {
            applicationList = this.loadConfigInfo(this.repository.findAll());
            applicationList = this.loadDeployInfo(applicationList);
        } else {
            Application application = this.repository.findByName(name.split("@")[0]);
            if (application == null) {
                application = new Application(name, Lists.newArrayList());
            }
            this.loadConfigInfo(application);
            this.loadDeployInfo(application);
            applicationList = Lists.newArrayList((Object[])new Application[]{application});
        }
        return applicationList;
    }

    @Override
    public Collection<Application> getRegisteredInstance(String name) {
        this.log.debug("getRegisteredInstance with name= {}", (Object)name);
        Collection<Application> allList = this.findAll(name);
        if (allList == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            List<ServiceInfoDomain> serviceList = this.serviceInfoMapper.getServicesInfo();
            if (serviceList == null || serviceList.isEmpty()) {
                return new ArrayList<Application>();
            }
            ArrayList<Application> resultList = new ArrayList<Application>();
            for (ServiceInfoDomain info : serviceList) {
                Optional<Application> optional = allList.stream().filter(application -> application.getName().equals(info.getName())).findFirst();
                if (!optional.isPresent()) continue;
                resultList.add(optional.get());
            }
            return resultList;
        }
        ServiceInfoDomain service = this.serviceInfoMapper.getServiceInfoByName(name);
        if (service == null) {
            return new ArrayList<Application>();
        }
        return allList.stream().filter(application -> application.getName().equals(service.getName())).collect(Collectors.toList());
    }

    @Override
    public Collection<Application> getApplicationListByCluster(String cluster) {
        Collection serviceInfoList = Optional.ofNullable(this.serviceInfoMapper.getServiceInfoListByCluster(cluster)).orElse(new ArrayList());
        Collection serviceInfoNames = serviceInfoList.stream().map(s -> s.getName()).collect(Collectors.toList());
        Collection applications = Optional.ofNullable(this.repository.findAll()).orElse(new ArrayList());
        return applications.stream().filter(application -> serviceInfoNames.contains(application.getName())).collect(Collectors.toList());
    }

    @Override
    public Collection<Instance> getInstanceListByCluster(String cluster) {
        Collection<Application> applicationList = this.getApplicationListByCluster(cluster);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    @Override
    public Instance findInstance(String id) {
        return this.repository.findInstance(id);
    }

    @Override
    public String getInstanceManagementUrl(String id) {
        return this.repository.getInstanceManagementUrl(id);
    }

    @Override
    public String proxy(String id, String method, ServletRequest request) throws Exception {
        return this.repository.proxy(id, method, request);
    }

    @Override
    public String proxyPost(String id, String method, String body, HttpServletRequest request) throws Exception {
        return this.repository.proxyPost(id, method, body, request);
    }

    @Override
    public ResultDto<String> logfile(String id, Long pos, int num) {
        return this.repository.logfile(id, pos, num);
    }

    @Override
    public String reStart(String instanceId) throws Exception {
        return this.repository.proxyPost(instanceId, "restart", null, null);
    }

    @Override
    public String sendCmdStart(Instance instance) throws Exception {
        List<DeployInfo> deployList = this.applicationInstallServiceDBMapper.getList();
        List tmp = deployList.stream().filter(a -> a.getIp().equals(instance.getIp()) && a.getPort() == instance.getPort()).collect(Collectors.toList());
        if (tmp.size() > 0) {
            DeployInfo deployInfo = (DeployInfo)tmp.get(0);
            return this.serviceInstall.sendCmdStart(deployInfo);
        }
        return "not DeployInfo,Start failed";
    }

    @Override
    public String shutDown(String instanceId) throws Exception {
        return this.repository.proxyPost(instanceId, "shutdown", null, null);
    }
}

