/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.service.EurekaOperationService;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EurekaOperationServiceImpl
implements EurekaOperationService {
    private final Logger log = LoggerFactory.getLogger(EurekaOperationServiceImpl.class);
    @Value(value="${eureka.client.serviceUrl.defaultZone:http://localhost:8761/eureka/}")
    private String eurekaUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstance(@NotNull String appName, @NotNull String instance) {
        String reqUrl = this.eurekaUrl;
        if (!reqUrl.endsWith("/")) {
            reqUrl = reqUrl + "/";
        }
        reqUrl = reqUrl + "apps/" + appName + "/" + instance;
        this.log.info("\u8bf7\u6c42\u6ce8\u518c\u4e2d\u5fc3\u5220\u9664\u5b9e\u4f8bURL: {}", (Object)reqUrl);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            httpClient.execute((HttpUriRequest)new HttpDelete(reqUrl), response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status != 200) {
                    this.log.error("\u5220\u9664Eureka\u5b9e\u4f8b\u5931\u8d25\uff0cAppName: {}, Instance: {}\u3002\u539f\u56e0:{}", new Object[]{appName, instance, response.getEntity().getContent()});
                } else {
                    this.log.info("\u5220\u9664Eureka\u5b9e\u4f8b\u6210\u529f\uff0cAppName: {}, Instance: {}", (Object)appName, (Object)instance);
                }
                return "";
            });
        }
        catch (IOException e) {
            this.log.error("\u8bf7\u6c42Eureka\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

