/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service;

import cn.com.yusys.yusp.control.governance.service.SendService;
import cn.com.yusys.yusp.msm.util.SpringContextUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SendServiceFactory {
    private static final Map<String, SendService> sendServiceMap = new ConcurrentHashMap<String, SendService>();

    public SendServiceFactory(List<SendService> sendServices) {
        for (SendService service : sendServices) {
            sendServiceMap.put(service.sendType(), service);
        }
    }

    public SendService getSendService(String sendType) {
        if (StringUtils.isNotEmpty((CharSequence)sendType)) {
            String[] sendServices;
            if (sendServiceMap.containsKey(sendType)) {
                return sendServiceMap.get(sendType);
            }
            for (String serviceStr : sendServices = SpringContextUtil.getBeanNamesForType(SendService.class)) {
                SendService service = (SendService)SpringContextUtil.getBean((String)serviceStr);
                if (!sendType.equals(service.sendType())) continue;
                sendServiceMap.put(service.sendType(), service);
                return service;
            }
        }
        throw new NullPointerException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d1\u9001\u7c7b\u578b[" + sendType + "]");
    }
}

