/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.repository;

import cn.com.yusys.yusp.control.governance.domain.BusinessDomain;
import cn.com.yusys.yusp.msm.config.CommonProperties;
import cn.com.yusys.yusp.msm.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.log.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class BusinessDomainRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(BusinessDomainRepository.class);

    public BusinessDomainRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{BusinessDomain.class});
    }

    public void addAndUpdateBussinessDomain(BusinessDomain domain) throws DashboardFileException {
        List<BusinessDomain> list = this.getBusinessDomainList();
        boolean update = false;
        for (BusinessDomain domain0 : list) {
            if (!domain0.getId().equals(domain.getId())) continue;
            update = true;
            BeanUtils.copyProperties((Object)domain, (Object)domain0);
        }
        if (!update) {
            list.add(domain);
        }
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            if (update) {
                this.log.error("\u66f4\u65b0\u4e1a\u52a1\u57df\u5931\u8d25: " + domain + " error: " + e.getMessage());
            } else {
                this.log.error("\u6dfb\u52a0\u4e1a\u52a1\u57df\u5931\u8d25: " + domain + " error: " + e.getMessage());
            }
            throw e;
        }
    }

    public void delBusinessDomain(String ids) {
        List<BusinessDomain> list = this.getBusinessDomainList();
        ArrayList<BusinessDomain> removeList = null;
        List<String> idList = Arrays.asList(ids.split(","));
        for (BusinessDomain domain0 : list) {
            if (!idList.contains(domain0.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<BusinessDomain>();
            }
            removeList.add(domain0);
        }
        if (removeList == null) {
            return;
        }
        list.removeAll(removeList);
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.log.error("\u5220\u9664\u4e1a\u52a1\u57df\u5931\u8d25: " + Arrays.asList(ids) + " error: " + e.getMessage());
        }
    }

    public List<BusinessDomain> getBusinessDomainList() {
        ArrayList list = (ArrayList)this.getLoadObj();
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public BusinessDomain getBusinessDomain(String id) {
        List list = (List)this.getLoadObj();
        BusinessDomain domain = null;
        for (BusinessDomain domain0 : list) {
            if (!domain0.getId().equals(id)) continue;
            domain = domain0;
        }
        return domain;
    }
}

