/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.install;

import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.install.DeployUtil;
import cn.com.yusys.yusp.control.governance.install.ServiceInstall;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallServiceDBMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ServiceInstallBatch {
    @Autowired
    ServiceInstall serviceInstall;
    @Autowired
    ApplicationInstallServiceDBMapper applicationInstallServiceDBMapper;
    @Autowired
    ServiceInfoMapper serviceInfoMapper;
    @Value(value="${startparam.jvmopts}")
    String jvmDefaultOpts;

    public void installBatch(VersionInfo versionInfo, List<HostDomain> hostDomainList, ModulNameConstant modulName) {
        if (hostDomainList == null) {
            return;
        }
        int total = hostDomainList.size();
        int deal = 0;
        ArrayList<DeployAndHost> deployList = new ArrayList<DeployAndHost>();
        LogUtil.info((Object)modulName, (String)"\u90e8\u7f72\u5f00\u59cb,\u5f85\u5904\u7406\u6570[{}]", (Object[])new Object[]{total});
        ServiceInfoDomain serviceInfoDomain = this.serviceInfoMapper.getServiceInfoByName(versionInfo.getName());
        String jvmOpts = this.configJvmOpts(serviceInfoDomain.getJvmConfiguration(), versionInfo);
        String bootOpts = this.configBootOpts(serviceInfoDomain.getProgramConfiguration(), versionInfo);
        for (HostDomain hostInfo : hostDomainList) {
            String deployId = DateTime.now().toString("yyyyMMddHHmmssSSS");
            DeployInfo deployInfo = this.buildDeploy(deployId, versionInfo, hostInfo);
            deployInfo.setJvmOpts(jvmOpts);
            deployInfo.setBootOpts(bootOpts);
            List<DeployInfo> previousDeployInfos = this.applicationInstallServiceDBMapper.getByAppNameAndHostIp(versionInfo.getName(), hostInfo.getIp());
            if (previousDeployInfos != null && previousDeployInfos.size() > 0) {
                deployInfo.setDeployId(previousDeployInfos.get(0).getDeployId());
                this.applicationInstallServiceDBMapper.update(deployInfo);
            } else {
                this.applicationInstallServiceDBMapper.add(deployInfo);
            }
            deployList.add(new DeployAndHost(hostInfo, deployInfo));
        }
        for (DeployAndHost list : deployList) {
            try {
                ++deal;
                this.serviceInstall.install(list.getDeployInfo(), versionInfo, list.getHostDomain());
            }
            catch (Exception e) {
                LogUtil.error((Object)modulName, (String)"[{}/{}]->\u5f02\u5e38\u9000\u51fa, {}", (Object[])new Object[]{--deal, total, e.getMessage()});
            }
        }
        LogUtil.info((Object)modulName, (String)"\u5e94\u7528\u542f\u52a8\u7ed3\u675f,\u5931\u8d25[{}],\u6210\u529f[{}]", (Object[])new Object[]{total - deal, deal});
    }

    private DeployInfo buildDeploy(String logId, VersionInfo versionInfo, HostDomain hostInfo) {
        String fileTargetPath = DeployUtil.getTargetPath(hostInfo);
        String logFileName = versionInfo.getName() + "_" + String.valueOf(logId);
        DeployInfo deployInfo = new DeployInfo();
        deployInfo.setDeployId(logId);
        deployInfo.setIp(hostInfo.getIp());
        deployInfo.setHostName(hostInfo.getHostName());
        deployInfo.setName(versionInfo.getName());
        deployInfo.setVersion(versionInfo.getVersion());
        deployInfo.setOpDate(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
        deployInfo.setStartTime(deployInfo.getOpDate());
        deployInfo.setAppName(versionInfo.getFileName());
        deployInfo.setLogFile(logFileName);
        deployInfo.setLogPath(DeployUtil.getLogPath(fileTargetPath));
        deployInfo.setDeployPath(fileTargetPath);
        return deployInfo;
    }

    private String configJvmOpts(String opts, VersionInfo versionInfo) {
        StringBuffer jvmOpts = new StringBuffer();
        if (StringUtils.isEmpty((String)opts)) {
            jvmOpts.append(this.jvmDefaultOpts.trim().replace(" ", "#"));
        } else {
            jvmOpts.append(opts.trim().replace(" ", "#"));
        }
        return jvmOpts.toString();
    }

    private String configBootOpts(String opts, VersionInfo versionInfo) {
        StringBuffer bootOpts = new StringBuffer();
        bootOpts.append("--eureka.instance.metadata-map.subversion");
        bootOpts.append("=");
        bootOpts.append(versionInfo.getVersion());
        if (!StringUtils.isEmpty((String)opts)) {
            bootOpts.append("#");
            bootOpts.append(opts.trim().replace(" ", "#"));
        }
        return bootOpts.toString();
    }

    class DeployAndHost {
        private HostDomain hostDomain;
        private DeployInfo deployInfo;

        DeployAndHost(HostDomain hostDomain, DeployInfo deployInfo) {
            this.hostDomain = hostDomain;
            this.deployInfo = deployInfo;
        }

        public HostDomain getHostDomain() {
            return this.hostDomain;
        }

        public void setHostDomain(HostDomain hostDomain) {
            this.hostDomain = hostDomain;
        }

        public DeployInfo getDeployInfo() {
            return this.deployInfo;
        }

        public void setDeployInfo(DeployInfo deployInfo) {
            this.deployInfo = deployInfo;
        }
    }
}

