/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.executor;

import cn.com.yusys.yusp.control.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceFileUtil {
    @Autowired
    private ServiceFileProperties serviceFileProperties;
    public static ServiceFileUtil serviceFileUtil;

    @PostConstruct
    public void init() {
        serviceFileUtil = this;
        ServiceFileUtil.serviceFileUtil.serviceFileProperties = this.serviceFileProperties;
    }

    public static VersionInfo getMaxVersionByName(String name) {
        List<VersionInfo> fileList = ServiceFileUtil.getServiceBasicInfo(name);
        VersionInfo versionInfo = null;
        if (fileList != null && !fileList.isEmpty()) {
            versionInfo = (VersionInfo)fileList.stream().sorted((s1, s2) -> s2.getVersion().compareTo(s1.getVersion())).collect(Collectors.toList()).get(0);
        }
        return versionInfo;
    }

    public static List<VersionInfo> getServiceBasicInfo(String serviceName) {
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return new ArrayList<VersionInfo>();
        }
        ArrayList<VersionInfo> serviceBasicInfoList = new ArrayList<VersionInfo>();
        List<VersionInfo> versionInfoList = ServiceFileUtil.getFileByServiceName(serviceName);
        if (null != versionInfoList && !versionInfoList.isEmpty()) {
            for (VersionInfo version : versionInfoList) {
                VersionInfo versionInfo = new VersionInfo();
                String fileName = version.getFileName();
                String[] nameSplit = fileName.split("_");
                String versionNo = nameSplit[0] == null ? "" : (nameSplit[0].indexOf("jenkins.") == -1 ? nameSplit[0] : nameSplit[1].replace(".jar", ""));
                versionInfo.setName(serviceName);
                versionInfo.setVersion(versionNo);
                versionInfo.setFileName(fileName);
                serviceBasicInfoList.add(versionInfo);
            }
        }
        return serviceBasicInfoList;
    }

    public static List<VersionInfo> getFileByServiceName(String serviceName) {
        ArrayList<VersionInfo> fileNameList = new ArrayList<VersionInfo>();
        String folderPath = ServiceFileUtil.serviceFileUtil.serviceFileProperties.getPath(serviceName);
        File directory = new File(folderPath);
        if (!directory.exists()) {
            return new ArrayList<VersionInfo>();
        }
        if (directory.isDirectory()) {
            File[] filelist = directory.listFiles();
            for (int i = 0; i < filelist.length; ++i) {
                if (filelist[i].isDirectory()) continue;
                VersionInfo versionInfo = new VersionInfo();
                String fileName = filelist[i].getName();
                versionInfo.setFileName(fileName);
                fileNameList.add(versionInfo);
            }
        }
        return fileNameList;
    }
}

