/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.gateway.web.rest;

import cn.com.yusys.yusp.control.gateway.service.IRefreshGateway;
import cn.com.yusys.yusp.control.gateway.service.ServiceLimiterService;
import cn.com.yusys.yusp.control.governance.domain.LimitArgs;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomainDTO;
import cn.com.yusys.yusp.control.governance.domain.ServiceLimitDomain;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.resource.Resource;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/servicelimiter"})
public class ServiceLimiterResource
extends Resource {
    private final Logger log = LoggerFactory.getLogger(ServiceLimiterResource.class);
    @Autowired
    private IRefreshGateway refreshGateway;

    ServiceLimiterService getServiceLimiterService() {
        return (ServiceLimiterService)this.getService(ServiceLimiterService.class);
    }

    @GetMapping(value={"/info"})
    public ResultDto<List<ServiceInfoDomain>> getServiceLimitInfo() {
        ResultDto list = new ResultDto(this.getServiceLimiterService().getServiceLimitInfo());
        list.setTotal((long)((List)list.getData()).size());
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u83b7\u53d6\u670d\u52a1\u9650\u6d41\u914d\u7f6e\u4fe1\u606f->\u6210\u529f", (Object[])new Object[0]);
        return list;
    }

    @GetMapping(value={"/paramsinfo"})
    public ResultDto<List<ServiceLimitDomain>> getLimitParameter(@RequestParam String name) {
        ResultDto result = new ResultDto();
        List<ServiceLimitDomain> list = this.getServiceLimiterService().getLimitParameter(name);
        if (list != null && list.size() > 0) {
            result.setData(list);
            result.setTotal((long)list.size());
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u83b7\u53d6\u9650\u6d41\u53c2\u6570\u4fe1\u606f->\u6210\u529f", (Object[])new Object[0]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/updateparams/{name}"})
    public ResultDto<Integer> updateLimitParameter(@RequestBody ServiceLimitDomain serviceLimitDomain, @PathVariable String name) {
        ResultDto resultDto;
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f[{}]->\u5f00\u59cb", (Object[])new Object[]{name});
        try {
            List<ServiceLimitDomain> list = this.getServiceLimiterService().getLimitParameter(name);
            if (list != null && list.size() > 0) {
                for (ServiceLimitDomain s : list) {
                    if (!s.getLimitMode().equals(serviceLimitDomain.getLimitMode())) continue;
                    serviceLimitDomain.setLimitArgs(s.getLimitArgs());
                }
            }
            ResultDto r = new ResultDto((Object)this.getServiceLimiterService().updateLimitParameter(name, serviceLimitDomain));
            LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f[{}]->\u6210\u529f", (Object[])new Object[]{name});
            resultDto = r;
        }
        catch (Exception e) {
            ResultDto resultDto2;
            try {
                LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f[{}]->\u5f02\u5e38\u9000\u51fa", (Object[])new Object[]{name});
                ResultDto r = new ResultDto();
                r.setCode(1);
                r.setMessage("\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f\u5f02\u5e38\u9000\u51fa");
                resultDto2 = r;
            }
            catch (Throwable throwable) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f[{}]->\u7ed3\u675f", (Object[])new Object[]{name});
                throw throwable;
            }
            LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f[{}]->\u7ed3\u675f", (Object[])new Object[]{name});
            return resultDto2;
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u4fee\u6539\u9650\u6d41\u53c2\u6570\u4fe1\u606f[{}]->\u7ed3\u675f", (Object[])new Object[]{name});
        return resultDto;
    }

    @GetMapping(value={"/getLimitArgs"})
    public ResultDto<List<LimitArgs>> getLimitArgs(@RequestParam String name, @RequestParam String limitMode, @RequestParam int page, @RequestParam int size) {
        ResultDto result = new ResultDto();
        List<ServiceLimitDomain> list = this.getServiceLimiterService().getLimitParameter(name);
        if (list != null && list.size() > 0) {
            for (ServiceLimitDomain s : list) {
                if (!s.getLimitMode().equals(limitMode)) continue;
                List<LimitArgs> limitArgs = s.getLimitArgs();
                if (limitArgs == null) break;
                int total = limitArgs.size();
                if (page > 0 && size > 0) {
                    limitArgs = size * (page - 1) < total ? limitArgs.subList(size * (page - 1), size * page > total ? total : size * page) : new ArrayList<LimitArgs>();
                }
                result.setData(limitArgs);
                result.setTotal((long)total);
                break;
            }
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u83b7\u53d6\u9650\u6d41\u53c2\u6570\u4fe1\u606f\u6269\u5c55\u4fe1\u606f->\u6210\u529f", (Object[])new Object[0]);
        return result;
    }

    @PostMapping(value={"/addLimitArgs"})
    public ResultDto<Integer> addLimitArgs(@RequestBody Map<String, String> reqMap) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ResultDto result = new ResultDto();
        List<ServiceLimitDomain> list = this.getServiceLimiterService().getLimitParameter(reqMap.get("name"));
        if (list != null && list.size() > 0) {
            for (ServiceLimitDomain s : list) {
                if (!s.getLimitMode().equals(reqMap.get("limitMode"))) continue;
                List<LimitArgs> limitArgs = s.getLimitArgs();
                LimitArgs o = new LimitArgs(reqMap.get("value"));
                if (limitArgs != null) {
                    if (!limitArgs.contains(o)) {
                        o.setCreatetime(sdf.format(new Date()));
                        limitArgs.add(0, o);
                    }
                } else {
                    limitArgs = new ArrayList<LimitArgs>();
                    o.setCreatetime(sdf.format(new Date()));
                    limitArgs.add(o);
                    s.setLimitArgs(limitArgs);
                }
                result = new ResultDto((Object)this.getServiceLimiterService().updateLimitParameter(reqMap.get("name"), s));
                break;
            }
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u6dfb\u52a0\u9650\u6d41\u53c2\u6570\u4fe1\u606f\u6269\u5c55\u4fe1\u606f->\u6210\u529f", (Object[])new Object[0]);
        return result;
    }

    @PostMapping(value={"/delLimitArgs"})
    public ResultDto<Integer> delLimitArgs(@RequestBody Map<String, String> reqMap) {
        ResultDto result = new ResultDto();
        List<ServiceLimitDomain> list = this.getServiceLimiterService().getLimitParameter(reqMap.get("name"));
        if (list != null && list.size() > 0) {
            for (ServiceLimitDomain s : list) {
                if (!s.getLimitMode().equals(reqMap.get("limitMode"))) continue;
                List<LimitArgs> limitArgs = s.getLimitArgs();
                LimitArgs o = new LimitArgs(reqMap.get("value"));
                if (limitArgs != null && limitArgs.contains(o)) {
                    limitArgs.remove(o);
                }
                result = new ResultDto((Object)this.getServiceLimiterService().updateLimitParameter(reqMap.get("name"), s));
                break;
            }
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_LIMITER, (String)"\u5220\u9664\u9650\u6d41\u53c2\u6570\u4fe1\u606f\u6269\u5c55\u4fe1\u606f->\u6210\u529f", (Object[])new Object[0]);
        return result;
    }

    @GetMapping(value={"/reflushConf"})
    public ResultDto<Map<String, String>> reflushConf() {
        String key = "zuul.RateLimitingFilter.data";
        List<ServiceInfoDomain> t = this.getServiceLimiterService().getServiceLimitInfo();
        ArrayList<ServiceInfoDomainDTO> dtoList = new ArrayList<ServiceInfoDomainDTO>();
        for (ServiceInfoDomain t_i : t) {
            ServiceInfoDomainDTO dto = new ServiceInfoDomainDTO();
            dto.setId(t_i.getId());
            dto.setName(t_i.getName());
            dto.setBusinessArea(t_i.getBusinessArea());
            dto.setLimitDomains(t_i.getLimitDomains());
            dtoList.add(dto);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            String value = mapper.writeValueAsString(dtoList);
            this.log.info("reflushConf:{}", (Object)value);
            return this.refreshGateway.reflushConf(key, value);
        }
        catch (Exception e) {
            ResultDto r = new ResultDto();
            r.setCode(1);
            r.setMessage("\u5b9e\u65f6\u5237\u65b0\u7f51\u5173\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38");
            return r;
        }
    }
}

