/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.gateway.service.impl;

import cn.com.yusys.yusp.control.gateway.service.ServiceLimiterService;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.ServiceLimitDomain;
import cn.com.yusys.yusp.control.governance.repository.ServiceInfoRepository;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="file")
public class ServiceLimiterServiceFileImpl
implements ServiceLimiterService {
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;

    public ServiceLimiterServiceFileImpl(ServiceInfoRepository serviceInfoRepository) {
        this.serviceInfoRepository = serviceInfoRepository;
    }

    @Override
    public List<ServiceInfoDomain> getServiceLimitInfo() {
        return this.serviceInfoRepository.getServiceInfos();
    }

    @Override
    public List<ServiceLimitDomain> getLimitParameter(String name) {
        ServiceInfoDomain s = this.serviceInfoRepository.getServiceInfoByName(name);
        String[] limitMode = new String[]{"IP", "LOGIN", "URI", "QPS", "TPS"};
        List<ServiceLimitDomain> list = null;
        if (s != null) {
            list = s.getLimitDomains();
        }
        ArrayList<ServiceLimitDomain> listR = new ArrayList<ServiceLimitDomain>();
        for (int i = 0; i < limitMode.length; ++i) {
            ServiceLimitDomain limitParam = new ServiceLimitDomain();
            limitParam.setLimitMode(limitMode[i]);
            limitParam.setIntervalPeriod("60");
            limitParam.setLimitValue("100");
            limitParam.setLimitState("I");
            if (list == null || !list.contains(limitParam)) {
                listR.add(limitParam);
                continue;
            }
            int index = list.indexOf(limitParam);
            listR.add(list.get(index));
        }
        return listR;
    }

    @Override
    public int updateLimitParameter(String name, ServiceLimitDomain serviceLimitDomain) {
        return this.serviceInfoRepository.upadteLimter(name, serviceLimitDomain, false, false);
    }
}

