/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.client.web.rest;

import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.control.client.domain.MsAuthClient;
import cn.com.yusys.yusp.control.client.domain.MsAuthResource;
import cn.com.yusys.yusp.control.client.service.AuthClientService;
import cn.com.yusys.yusp.control.client.service.AuthResService;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth/client"})
public class AuthClientResource {
    private static Logger logger = LoggerFactory.getLogger(AuthClientResource.class);
    @Autowired
    private AuthResService authResService;
    @Autowired
    private AuthClientService authClientService;

    @GetMapping(value={"/getclientsbyparams"})
    public ResultDto<List<MsAuthClient>> getClientsByParams(@RequestParam(required=false) String clientId, @RequestParam(required=false) String systemId, @RequestParam(required=false) String serviceName) {
        serviceName = clientId;
        clientId = null;
        ResultDto resultDto = new ResultDto(this.authClientService.getClientsByParams(clientId, systemId, serviceName));
        LogUtil.info((Object)"authClient", (String)("\u83b7\u53d6" + (StringUtils.isEmpty((Object)clientId) ? "" : "clientId:{}") + (StringUtils.isEmpty((Object)systemId) ? "" : " systemId:{}") + (StringUtils.isEmpty((Object)serviceName) ? "" : " serviName:{}") + "\u7684\u5ba2\u6237\u7aef\u5217\u8868->\u6210\u529f"), (Object[])new Object[]{clientId, systemId, serviceName});
        return resultDto;
    }

    @GetMapping(value={"/getauthresbyid"})
    public ResultDto<List<MsAuthResource>> getAuthResById(String clientId) {
        ResultDto resultDto = new ResultDto(this.authResService.getAuthResById(clientId));
        LogUtil.info((Object)"authClient", (String)"\u83b7\u53d6clientId:{}\u7684\u6388\u6743\u670d\u52a1\u5217\u8868->\u6210\u529f", (Object[])new Object[]{clientId});
        return resultDto;
    }

    @PostMapping(value={"/saveorupdateclient"})
    public ResultDto<MsAuthClient> saveOrUpdateClient(@RequestBody MsAuthClient msAuthClient) {
        ResultDto resultDto = new ResultDto((Object)this.authClientService.saveOrUpdateClient(msAuthClient));
        return resultDto;
    }

    @PostMapping(value={"/deleteClientByClientId"})
    public ResultDto<Integer> deleteClientByClientId(@RequestBody String ids) {
        ResultDto resultDto = new ResultDto((Object)this.authClientService.deleteClientByClientId(ids));
        LogUtil.info((Object)"authClient", (String)"\u6279\u91cf\u5220\u9664\u5ba2\u6237\u7aef:{}->\u6210\u529f", (Object[])new Object[]{ids});
        return resultDto;
    }

    @PostMapping(value={"/authservice2client"})
    public ResultDto authservice2client(@RequestParam String clientId, @RequestParam String resIds) {
        ResultDto resultDto = new ResultDto();
        try {
            this.authClientService.authService2Client(clientId, resIds);
            LogUtil.info((Object)"authClient", (String)"\u6388\u6743\u7ed9\u5ba2\u6237\u7aef:{}\u7684\u670d\u52a1\uff1a{}-->\u6388\u6743\u670d\u52a1\u6210\u529f", (Object[])new Object[]{clientId, resIds});
        }
        catch (Exception e) {
            LogUtil.warn((Object)"authClient", (String)"\u6388\u6743\u7ed9\u5ba2\u6237\u7aef:{}\u7684\u670d\u52a1\uff1a{}-->\u6388\u6743\u670d\u52a1\u5931\u8d25", (Object[])new Object[]{clientId, resIds});
            resultDto.setCode(500);
            resultDto.setMessage("\u6388\u6743\u670d\u52a1\u5931\u8d25\uff01");
        }
        return resultDto;
    }

    @PostMapping(value={"/deleteauthservices"})
    public ResultDto deleteAuthRes(@RequestParam String clientId, @RequestParam String resIds) {
        ResultDto dto = new ResultDto();
        try {
            this.authClientService.deleteAuthServices(clientId, resIds);
            LogUtil.info((Object)"authClient", (String)"\u6279\u91cf\u5220\u9664\u6388\u6743\u7ed9\u5ba2\u6237\u7aef:{}\u7684\u670d\u52a1\u5217\u8868:{}->\u6210\u529f", (Object[])new Object[]{clientId, resIds});
        }
        catch (Exception e) {
            LogUtil.warn((Object)"authClient", (String)"\u6279\u91cf\u5220\u9664\u6388\u6743\u7ed9\u5ba2\u6237\u7aef:{}\u7684\u670d\u52a1\u5217\u8868:{}->\u5220\u9664\u6388\u6743\u5f02\u5e38", (Object[])new Object[]{clientId, resIds});
            dto.setCode(500);
            dto.setMessage("\u5220\u9664\u6388\u6743\u5f02\u5e38!");
        }
        return dto;
    }
}

