/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.client.service;

import cn.com.yusys.yusp.control.client.domain.MsAuthClient;
import cn.com.yusys.yusp.control.client.repository.mapper.AuthClientMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthClientService {
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private AuthClientMapper authClientMapper;

    public List<MsAuthClient> getClientsByParams(String clientId, String systemId, String serviceName) {
        return this.authClientMapper.getClientsByParams(clientId, systemId, serviceName);
    }

    public List<MsAuthClient> getClientsByServiceId(String serviceId) {
        return this.authClientMapper.getClientsByServiceId(serviceId);
    }

    public MsAuthClient saveOrUpdateClient(MsAuthClient msAuthClient) {
        boolean aleradyExists = false;
        String existsClientId = "";
        for (MsAuthClient mac : this.authClientMapper.getClientsByParams(null, null, null)) {
            if (!mac.getServiceName().equals(msAuthClient.getServiceName()) || !mac.getSystemId().equals(msAuthClient.getSystemId())) continue;
            aleradyExists = true;
            existsClientId = mac.getClientId();
            break;
        }
        if (StringUtils.isEmpty((CharSequence)msAuthClient.getClientId()) ? aleradyExists : aleradyExists && !msAuthClient.getClientId().equals(existsClientId)) {
            return null;
        }
        String userName = SecurityContextHolder.getContext().getAuthentication().getName();
        if (StringUtils.isEmpty((CharSequence)msAuthClient.getClientId())) {
            msAuthClient.setClientId(UUID.randomUUID().toString().replace("-", ""));
            String time = formatter.format(LocalDateTime.now());
            msAuthClient.setCreator(userName);
            msAuthClient.setCreateTime(time);
            msAuthClient.setUpdateUser(msAuthClient.getCreator());
            msAuthClient.setUpdateTime(time);
            msAuthClient.setClientSecret(new BCryptPasswordEncoder().encode((CharSequence)msAuthClient.getClientSecret()));
            msAuthClient.setScope("amdin");
            this.authClientMapper.saveClient(msAuthClient);
            LogUtil.info((Object)"authClient", (String)"\u65b0\u589e\u5ba2\u6237\u7aef,\u5ba2\u6237\u7aefId:{}", (Object[])new Object[]{msAuthClient.getClientId()});
        } else {
            List<MsAuthClient> oldClients = this.authClientMapper.getClientsByParams(msAuthClient.getClientId(), null, null);
            if (oldClients == null || oldClients.size() != 1) {
                LogUtil.error((Object)"authClient", (String)"\u5ba2\u6237\u7aefId:{}\u7684\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728", (Object[])new Object[]{msAuthClient.getClientId()});
            }
            MsAuthClient old = oldClients.get(0);
            msAuthClient.setUpdateUser(userName);
            this.authClientMapper.updateClient(this.merge(msAuthClient, old));
            LogUtil.info((Object)"authClient", (String)"\u4fee\u6539\u5ba2\u6237\u7aef\uff0c\u5ba2\u6237\u7aefId:{}", (Object[])new Object[]{msAuthClient.getClientId()});
        }
        return msAuthClient;
    }

    private MsAuthClient merge(MsAuthClient client, MsAuthClient old) {
        if (StringUtils.isEmpty((CharSequence)client.getClientSecret())) {
            client.setClientSecret(old.getClientSecret());
        }
        if (StringUtils.isEmpty((CharSequence)client.getScope())) {
            client.setScope(old.getScope());
        }
        if (StringUtils.isEmpty((CharSequence)client.getSystemId())) {
            client.setSystemId(old.getSystemId());
        }
        if (StringUtils.isEmpty((CharSequence)client.getServiceName())) {
            client.setServiceName(old.getServiceName());
        }
        return client;
    }

    public int deleteClientByClientId(String ids) {
        for (String id : ids.split(",")) {
            this.authClientMapper.deleteAuthServices(id, null);
        }
        return this.authClientMapper.deleteClientByClientId(ids.split(","));
    }

    public int deleteAuthServices(String clientId, String resIds) {
        return this.authClientMapper.deleteAuthServices(clientId, resIds.split(","));
    }

    public int authService2Client(String clientId, String resIds) {
        ArrayList<Map<String, String>> relList = new ArrayList<Map<String, String>>();
        for (String s : resIds.split(",")) {
            HashMap<String, String> relMap = new HashMap<String, String>();
            relMap.put("clientId", clientId);
            relMap.put("resId", s);
            relMap.put("id", UUID.randomUUID().toString().replace("-", ""));
            relList.add(relMap);
        }
        return this.authClientMapper.authService2Client(relList);
    }
}

