/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.apollo.test;

import cn.com.yusys.yusp.control.apollo.test.SampleRedisConfig;
import cn.com.yusys.yusp.control.apollo.test.UseConfigurationProperties;
import cn.com.yusys.yusp.control.apollo.test.UseValue;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"redis.cache.enabled"})
@Component
public class SpringBootApolloRefreshConfig {
    private static final Logger logger = LoggerFactory.getLogger(SpringBootApolloRefreshConfig.class);
    @Autowired
    private SampleRedisConfig sampleRedisConfig;
    @Autowired
    private RefreshScope refreshScope;
    @Autowired
    private UseConfigurationProperties useConfigurationProperties;
    @Autowired
    private UseValue useValue;

    @ApolloConfigChangeListener
    public void onChange(ConfigChangeEvent changeEvent) {
        boolean redisCacheKeysChanged = false;
        for (String changedKey : changeEvent.changedKeys()) {
            if (!changedKey.startsWith("redis.cache")) continue;
            redisCacheKeysChanged = true;
            break;
        }
        if (!redisCacheKeysChanged) {
            return;
        }
        logger.info("before refresh {}", (Object)this.sampleRedisConfig.toString());
        this.refreshScope.refreshAll();
        logger.info("after refresh {}", (Object)this.sampleRedisConfig.toString());
        logger.info("after refresh {}", (Object)this.useConfigurationProperties.toString());
    }
}

