/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.util;

import cn.com.yusys.yusp.msm.ssh.cmd.SimpleCmd;
import cn.com.yusys.yusp.msm.ssh.session.SimpleSshSession;
import com.jcraft.jsch.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostUtils {
    private static final Logger logger = LoggerFactory.getLogger(HostUtils.class);

    private HostUtils() {
    }

    public static String getCpuUsage(SimpleSshSession session) throws Exception {
        String[] cpus = session.goCmd("vmstat").split("\n")[2].split(" ");
        ArrayList<String> cpuList = new ArrayList<String>();
        for (String s : cpus) {
            if (s.isEmpty()) continue;
            cpuList.add(s);
        }
        int usage = 100 - Integer.parseInt((String)cpuList.get(cpuList.size() - 3));
        logger.info("cpu\u4f7f\u7528\u7387:{}", (Object)usage);
        return String.valueOf(usage);
    }

    public static final String getMemoryUsage(SimpleSshSession sshSession) throws Exception {
        String[] totals = sshSession.goCmd("free -kt").split("\n")[3].split(" ");
        double[] rec = new double[2];
        int count = 0;
        for (String s : totals) {
            if (s.isEmpty()) continue;
            if (count >= 1) {
                rec[count - 1] = Double.parseDouble(s);
                if (count == 2) break;
            }
            ++count;
        }
        String usage = (int)(rec[1] / rec[0] * 100.0) + "%";
        logger.info("\u5185\u5b58\u4f7f\u7528\u7387\uff1a{}", (Object)usage);
        return usage;
    }

    public static final String goCmd(Session session, String cmd) throws Exception {
        return new SimpleSshSession(session).goCmd(cmd);
    }

    public static final int getProcessCount(SimpleSshSession session, String name) throws Exception {
        String num = session.goCmd(SimpleCmd.catProcessCount(name)).trim();
        return StringUtils.isEmpty((CharSequence)num) ? 0 : Integer.parseInt(num);
    }

    public static final Map<String, String> catHostInfo(SimpleSshSession session) throws Exception {
        HashMap<String, String> hards = new HashMap<String, String>();
        hards.put("cpu", HostUtils.getCpuUsage(session));
        hards.put("Mem", HostUtils.getMemoryUsage(session));
        return hards;
    }

    public static final Map<String, Integer> catProcessList(String instances, SimpleSshSession session) throws Exception {
        String[] inss;
        HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
        for (String s : inss = instances.toString().split(",")) {
            integerMap.put(s, HostUtils.getProcessCount(session, s));
        }
        return integerMap;
    }
}

