/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.storage.service;

import cn.com.yusys.yusp.msm.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.msm.util.SpringContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceFactory {
    private ConfigFileConfiguration fileConfig;

    private StorageServiceFactory(ConfigFileConfiguration fileConfig) {
        this.fileConfig = fileConfig;
    }

    public <T> T getStorageService(Class<T> clazzT) {
        ArrayList<String> classBeanNames = new ArrayList<String>(Arrays.asList(SpringContextUtil.getBeanNamesForType(clazzT)));
        for (String str : classBeanNames) {
            Object t = SpringContextUtil.getBean(str);
            StorageType storageServiceBean = t.getClass().getAnnotation(StorageType.class);
            if (!Objects.nonNull(storageServiceBean) || !Objects.equals(this.fileConfig.getFileType(), storageServiceBean.serviceType())) continue;
            return t;
        }
        return null;
    }
}

