/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.ssh.session;

import cn.com.yusys.yusp.msm.exception.DashboardSessionException;
import cn.com.yusys.yusp.msm.ssh.common.ConnectionInfo;
import cn.com.yusys.yusp.msm.ssh.session.SimpleSshSession;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SshSessionFactory.class);
    private static final SshSessionFactory _instance = SshSessionFactoryHolder.access$100();

    private SshSessionFactory() {
    }

    public static final SshSessionFactory getInstance() {
        return _instance;
    }

    public final SimpleSshSession getSession(ConnectionInfo ci) throws DashboardSessionException {
        if (Objects.isNull(ci)) {
            throw new DashboardSessionException("\u4e3b\u673a\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        Session session = null;
        try {
            session = new JSch().getSession(ci.getUserName(), ci.getUri());
            session.setConfig("PreferredAuthentications", "password");
            session.setConfig("StrictHostKeyChecking", "no");
            session.setPassword(ci.getPassword());
        }
        catch (JSchException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new SimpleSshSession(session);
    }

    private static final class SshSessionFactoryHolder {
        private static final SshSessionFactory _INSTANCE = new SshSessionFactory();

        private SshSessionFactoryHolder() {
        }

        static /* synthetic */ SshSessionFactory access$100() {
            return _INSTANCE;
        }
    }
}

