/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.log.web.rest;

import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.exception.DashboardParamException;
import cn.com.yusys.yusp.msm.log.domain.OperationLog;
import cn.com.yusys.yusp.msm.log.service.OperationLogService;
import cn.com.yusys.yusp.msm.resource.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/operationlog"})
public class OperationLogResource
extends Resource {
    private final Logger log = LoggerFactory.getLogger(OperationLogResource.class);

    OperationLogService OperationLogService() {
        return this.getService(OperationLogService.class);
    }

    @GetMapping(value={"/{name}"})
    public ResultDto<List<OperationLog>> getListByName(@PathVariable String name, @RequestParam(value="num") int num) {
        return new ResultDto<List<OperationLog>>(this.OperationLogService().getListByName(name, num));
    }

    @PostMapping(value={""})
    public ResultDto<String> insert(@RequestBody OperationLog operationLog) {
        try {
            this.OperationLogService().insert(operationLog);
        }
        catch (DashboardParamException e) {
            this.log.error("insert failed, message:{}", (Object)e.getMessage());
            return new ResultDto<String>(1005, 0L, "error", e.getMessage());
        }
        return new ResultDto<String>("success");
    }
}

