/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.log.util;

import cn.com.yusys.yusp.msm.exception.DashboardParamException;
import cn.com.yusys.yusp.msm.log.domain.OperationLog;
import cn.com.yusys.yusp.msm.log.service.OperationLogService;
import cn.com.yusys.yusp.msm.log.util.LogLevelConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageServiceFactory;
import cn.com.yusys.yusp.msm.util.SpringContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LogUtil.class);

    public static void info(Object name, String opNote, Object ... param) {
        LogUtil.addLog(name, opNote, LogLevelConstant.INFO.name(), param);
    }

    public static void warn(Object name, String opNote, Object ... param) {
        LogUtil.addLog(name, opNote, LogLevelConstant.WARN.name(), param);
    }

    public static void error(Object name, String opNote, Object ... param) {
        LogUtil.addLog(name, opNote, LogLevelConstant.ERROR.name(), param);
    }

    private static void addLog(OperationLog operationLog) {
        String level = operationLog.getLevel();
        try {
            Method levelMethod = LOG.getClass().getDeclaredMethod(level.toLowerCase(), String.class);
            levelMethod.invoke((Object)LOG, operationLog.getOpNote());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException levelMethod) {
            // empty catch block
        }
        StorageServiceFactory factory = SpringContextUtil.getBean(StorageServiceFactory.class);
        OperationLogService service = factory.getStorageService(OperationLogService.class);
        try {
            service.insert(operationLog);
        }
        catch (DashboardParamException e) {
            LOG.error("add logg info error, message:{}", (Object)e.getMessage());
        }
    }

    private static void addLog(Object name, String opNote, String level, Object ... param) {
        if (param != null && param.length > 0) {
            opNote = MessageFormatter.arrayFormat((String)opNote, (Object[])param).getMessage();
        }
        OperationLog operationLog = new OperationLog();
        operationLog.setName(name.toString());
        operationLog.setOpNote(opNote);
        operationLog.setLevel(level);
        operationLog.setThreadId(String.valueOf(Thread.currentThread().getId()));
        LogUtil.addLog(operationLog);
    }

    public static String converClassName(String className) {
        String firstName = className.substring(0, 1);
        return firstName.toLowerCase() + className.substring(1);
    }
}

